//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.taskmodel.filter;

import com.google.common.base.Predicate;

import de.ugoe.cs.autoquest.eventcore.IEventTarget;
import de.ugoe.cs.autoquest.eventcore.IEventType;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskModel;
import de.ugoe.cs.autoquest.usability.taskmodel.filter.types.EventTargetFilter;
import de.ugoe.cs.autoquest.usability.taskmodel.filter.types.EventTypeFilter;
import de.ugoe.cs.autoquest.usability.taskmodel.filter.types.TaskTypeFilter;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class TaskModelFilter implements ITaskModelFilter {

	private BFSTaskModelIterator taskModelIterator;

	private FilterResult filterStatistic;

	@SuppressWarnings("unchecked")
	@Override
	public FilterResult filter(ITaskModel taskModel,
			EventTargetFilter eventTarget) {
		Predicate<IEventTarget> filterPredicate = eventTarget.filterPredicate();
		return setup(taskModel, filterPredicate);
	}

	@SuppressWarnings("unchecked")
	@Override
	public FilterResult filter(ITaskModel taskModel, EventTypeFilter eventType) {
		Predicate<IEventType> filterPredicate = eventType.filterPredicate();
		return setup(taskModel, filterPredicate);
	}

	@SuppressWarnings("unchecked")
	@Override
	public FilterResult filter(ITaskModel taskModel, TaskTypeFilter nodeType) {
		Predicate<ITask> filterPredicate = nodeType.filterPredicate();
		return setup(taskModel, filterPredicate);
	}

	private FilterResult setup(ITaskModel taskModel,
			Predicate<?> filterPredicate) {
		this.filterStatistic = new FilterResult(filterPredicate);
		this.taskModelIterator = BFSTaskModelIterator.iterator(taskModel);
		traverse(taskModel);
		return this.filterStatistic;
	}

	private void traverse(ITaskModel taskModel) {
		while (this.taskModelIterator.hasNext()) {
			ITask task = this.taskModelIterator.next();
			this.filterStatistic.addTask(task);
		}
	}
}
