//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.util;

import java.util.Collection;

import com.google.common.collect.Iterables;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.usability.rules.patterns.InteractionPatternVisitor;

/**
 * <p>
 * Util class for {@link InteractionPatternVisitor}.
 * </p>
 * 
 * @author Alexander Deicke
 */
public class PatternsVisitorUtil {

    private PatternsVisitorUtil() {
        // no instantiation
    }

    /**
     * <p>
     * Gets the first sub task.
     * </p>
     * 
     * @param tasks
     *            collection of tasks
     * @return first sub task
     */
    public static ITask firstSubtaskOf(Collection<ITask> tasks) {
        return Iterables.getFirst(tasks, new NullTask());
    }

    /**
     * <p>
     * Gets the last sub task.
     * </p>
     * 
     * @param tasks
     *            collection of tasks
     * @return last sub task
     */
    public static ITask lastSubTaskOf(Collection<ITask> tasks) {
        return Iterables.getLast(tasks, new NullTask());
    }

}
