//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.util;

import org.junit.*;
import static org.junit.Assert.*;

/**
 * The class <code>ArrayToolsTest</code> contains tests for the class
 * <code>{@link ArrayTools}</code>.
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class ArrayToolsTest {

	Integer array[];

	@Test
	public void testFindIndex_1() throws Exception {
		Integer target = 3;
		int expected = 3;

		int result = ArrayTools.findIndex(array, target);

		assertEquals(expected, result);
	}

	@Test
	public void testFindIndex_2() throws Exception {
		Integer target = 4;
		int expected = 4;

		int result = ArrayTools.findIndex(array, target);

		assertEquals(expected, result);
	}

	@Test
	public void testFindIndex_3() throws Exception {
		Integer target = 7;

		int result = ArrayTools.findIndex(array, target);
		int expected = -1;
		
		assertEquals(expected, result);
	}

	@Test
	public void testFindIndex_4() throws Exception {
		Integer target = null;
		int result = ArrayTools.findIndex(array, target);
		int expected = 7;
		assertEquals(expected, result);
	}

	@Test
	public void testFindIndex_5() throws Exception {
		Object[] array = new Object[0];
		Object other = new Object();

		int result = ArrayTools.findIndex(array, other);

		assertEquals(-1, result);
	}
	
	@Test
	public void testFindMax_1() throws Exception {
		int expected = 8;
		
		int result = ArrayTools.findMax(array);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testFindMax_2() throws Exception {
		Integer[] arrayUnsorted = new Integer[]{2,3,6,1,8,9,1,1,3,15,4,0,-1};
		int expected = 9;
		
		int result = ArrayTools.findMax(arrayUnsorted);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testFindMax_3() throws Exception {
		Integer[] arrayUnsorted = new Integer[]{2,3,6,1,8,9,1,1,3,15,4,15,-1};
		int expected = 9;
		
		int result = ArrayTools.findMax(arrayUnsorted);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testFindMax_4() throws Exception {
		Integer[] arrayNoLenght = new Integer[]{};
		int expected = -1;
		
		int result = ArrayTools.findMax(arrayNoLenght);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testFindMax_5() throws Exception {
		Integer[] arrayNulls = new Integer[]{null, null};
		int expected = -1;
		
		int result = ArrayTools.findMax(arrayNulls);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testFindMax_6() throws Exception {
		int expected = 9;
		
		double[] array = {2,3,6,1,8,9,1,1,3,15,4,15,-1};
		
		int result = ArrayTools.findMax(array);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testFindMin_1() throws Exception {
		int expected = 0;
		
		int result = ArrayTools.findMin(array);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testFindMin_2() throws Exception {
		Integer[] arrayUnsorted = new Integer[]{2,3,6,1,8,9,1,1,-3,15,4,0,-1};
		int expected = 8;
		
		int result = ArrayTools.findMin(arrayUnsorted);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testFindMin_3() throws Exception {
		Integer[] arrayUnsorted = new Integer[]{2,3,6,1,8,9,1,-1,3,15,4,15,-1};
		int expected = 7;
		
		int result = ArrayTools.findMin(arrayUnsorted);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testFindMin_4() throws Exception {
		Integer[] arrayNoLenght = new Integer[]{};
		int expected = -1;
		
		int result = ArrayTools.findMin(arrayNoLenght);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testFindMin_5() throws Exception {
		Integer[] arrayNulls = new Integer[]{null, null};
		int expected = -1;
		
		int result = ArrayTools.findMin(arrayNulls);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testFindMin_6() throws Exception {
		int expected = -1;
		
		int result = ArrayTools.findMin(null);
		
		assertEquals(expected, result);
	}

	@Before
	public void setUp() throws Exception {
		array = new Integer[] { 0, 1, 2, 3, 4, 4, 5, null, 6 };
	}

	public static void main(String[] args) {
		new org.junit.runner.JUnitCore().run(ArrayToolsTest.class);
	}
}