package de.ugoe.cs.autoquest.tasktrees.alignment.substitution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import de.ugoe.cs.autoquest.eventcore.guimodel.GUIModel;
import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElement;

import java.util.List;

import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.autoquest.tasktrees.alignment.algorithms.AlignmentHelpers;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTaskInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IUserSession;
import de.ugoe.cs.util.console.GlobalDataContainer;

public class ObjectDistanceSubstitionMatrix implements SubstitutionMatrix {

	private ArrayList<int[][]> matrix;
	private int currentSequence;
	
	
	public ObjectDistanceSubstitionMatrix() {
		currentSequence = 0;
		matrix = new ArrayList<int[][]>();
	}
	
	@Override
	public String info() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public double getDistance(int pos1, int pos2) {
		// TODO Auto-generated method stub
		
		return matrix.get(currentSequence)[pos1][pos2];
	}
	
	public double getDistance(int sequence, int pos1, int pos2) {
		return  matrix.get(sequence)[pos1][pos2];
		
		
	}

	@Override
	public double getGapPenalty() {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public void generate(List<IUserSession> sessions) {
		
		for(Iterator it = sessions.iterator(); it.hasNext();) {
			IUserSession session = (IUserSession) it.next();
			matrix.add(new int[sessions.size()][sessions.size()]);
		
			
			for (int i=0; i < session.size(); i++) {
				for (int j=0; j < session.size(); j++) {
					//TODO Check if ITaskInstance is of type IEventTaskInstance 
					IEventTaskInstance eti1 = (IEventTaskInstance) session.get(i);
					IEventTaskInstance eti2 = (IEventTaskInstance) session.get(j);
					IGUIElement first = (IGUIElement) eti1.getEvent().getTarget();
					IGUIElement second =(IGUIElement) eti2.getEvent().getTarget();
					matrix.get(currentSequence)[i][j] = AlignmentHelpers.distanceBetween(first, second);
				}
			}			
		}
	}
}
