package de.ugoe.cs.autoquest.tasktrees.alignment.substitution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

import de.ugoe.cs.autoquest.eventcore.guimodel.GUIModel;
import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElement;

import java.util.List;

import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.autoquest.tasktrees.alignment.algorithms.AlignmentHelpers;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTaskInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IUserSession;
import de.ugoe.cs.autoquest.usageprofiles.SymbolMap;
import de.ugoe.cs.util.console.GlobalDataContainer;

public class ObjectDistanceSubstitionMatrix implements SubstitutionMatrix {

	// private ArrayList<int[][]> matrix;
	HashMap<Integer, Integer> idmapping;
	private TriangleMatrix matrix;
	private SymbolMap<ITaskInstance, ITask> uniqueTasks;

	public ObjectDistanceSubstitionMatrix(
			SymbolMap<ITaskInstance, ITask> uniqueTasks) {
		this.uniqueTasks = uniqueTasks;
		idmapping = new HashMap<Integer, Integer>();
		matrix = new TriangleMatrix(uniqueTasks.size()+1);
	}

	@Override
	public float getGapPenalty() {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public void generate() {
		int i = 0;
		for (Iterator<ITaskInstance> it = uniqueTasks.getSymbols().iterator(); it
				.hasNext();) {
			Object obj1 = it.next();
			IEventTaskInstance eti1 = null;
			if (obj1 instanceof IEventTaskInstance) {
				eti1 = (IEventTaskInstance) obj1;
			}
			int j = 0;
			for (Iterator<ITaskInstance> jt = uniqueTasks.getSymbols()
					.iterator(); jt.hasNext();) {
				IEventTaskInstance eti2 = null;
				Object obj2 = jt.next();
				if (obj2 instanceof IEventTaskInstance) {
					eti2 = (IEventTaskInstance) obj2;
				}
				IGUIElement first = (IGUIElement) eti1.getEvent().getTarget();
				IGUIElement second = (IGUIElement) eti2.getEvent().getTarget();
				idmapping.put(eti1.getTask().getId(), i);
				idmapping.put(eti2.getTask().getId(), j);
				matrix.set(i, j, AlignmentHelpers.distanceBetween(first, second));
				j++;
			}
			i++;
		}
	}

	@Override
	public float getDistance(int taskId1, int taskId2) {
		return matrix.get(idmapping.get(taskId1),idmapping.get(taskId2));
	}

}

