package de.ugoe.cs.autoquest.tasktrees.alignment.substitution;

public class TriangleMatrix {
	
	private float[] matrix;
	private int size;
	
	public TriangleMatrix(int size) {
		this.size = size;
		matrix = new float [size*(size+1)/2];
	}
	
	public float get(int first, int second) {
		int row = Math.min(first, second);
		int col = Math.max(first, second);
		return matrix[row*size-(row*(row+1)/2 - (size-col))];
		
	}
	
	public void set(int first, int second, float value) {
		int row = Math.min(first, second);
		int col = Math.max(first, second);
		matrix[row*size-(row*(row+1)/2 - (size-col))] = value;
	}

	
	
	
	//Note: String just looks good for small. testing matrices 
	public String toString() {
		String result = "";
		for (int i = 0; i < size; i++) {
			for(int j = 0; j< size; j++) {
				if(i<j) {
					result = result + String.format("%+4.1f",this.get(i,j));
				}
				else {
					result = result + ("      ");
				}
			}
			result = result + "\n";
		}
		return result;
	}
}
