package de.ugoe.cs.autoquest.tasktrees.alignment.substitution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

import de.ugoe.cs.autoquest.eventcore.guimodel.GUIModel;
import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElement;

import java.util.List;

import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.autoquest.tasktrees.alignment.algorithms.AlignmentHelpers;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTaskInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IUserSession;
import de.ugoe.cs.autoquest.usageprofiles.SymbolMap;
import de.ugoe.cs.util.console.GlobalDataContainer;

public class ObjectDistanceSubstitionMatrix implements SubstitutionMatrix {

	// private ArrayList<int[][]> matrix;
	HashMap<Integer, Integer> idmapping;
	private TriangleMatrix matrix;
	private SymbolMap<ITaskInstance, ITask> uniqueTasks;
	private float gapPenalty; 
	private float positiveThreshold;
	
	public ObjectDistanceSubstitionMatrix(
			SymbolMap<ITaskInstance, ITask> uniqueTasks,float positiveThreshold) {
		this.uniqueTasks = uniqueTasks;
		this.positiveThreshold = positiveThreshold;
		idmapping = new HashMap<Integer, Integer>();
		matrix = new TriangleMatrix(uniqueTasks.size()+1);
		gapPenalty = -10;
		
	}

	@Override
	public float getGapPenalty() {
		return gapPenalty;
	}

	@Override
	public void generate() {
		int index = 0;
		//TODO We need to determine this parameter before generating the matrix..
		float meandistance = 18;
		//TODO We need to determine this parameter before generating the matrix..
		float maxDistance =34;
		for (Iterator<ITaskInstance> it = uniqueTasks.getSymbols().iterator(); it
				.hasNext();) {
			Object obj1 = it.next();
			IEventTaskInstance eti1 = null;
			if (obj1 instanceof IEventTaskInstance) {
				eti1 = (IEventTaskInstance) obj1;
			}
		
			for (Iterator<ITaskInstance> jt = uniqueTasks.getSymbols()
					.iterator(); jt.hasNext();) {
				IEventTaskInstance eti2 = null;
				Object obj2 = jt.next();
				if (obj2 instanceof IEventTaskInstance) {
					eti2 = (IEventTaskInstance) obj2;
				}
				IGUIElement first = (IGUIElement) eti1.getEvent().getTarget();
				IGUIElement second = (IGUIElement) eti2.getEvent().getTarget();
				int tempindex1 = -1;
				int tempindex2 = -1;
				if(!idmapping.containsKey(eti1.getTask().getId()))
				{
					idmapping.put(eti1.getTask().getId(), index);
					tempindex1 = index;
					index++;
				}	
				else 
				{
					tempindex1 = idmapping.get(eti1.getTask().getId());
				}	
				if(!idmapping.containsKey(eti2.getTask().getId()))
				{
					idmapping.put(eti2.getTask().getId(), index);
					tempindex2 = index;
					index++;
				}	
				else 
				{
					tempindex2 = idmapping.get(eti2.getTask().getId());
				}
				float distance = -1*AlignmentHelpers.distanceBetween(first, second);
				//meandistance += distance;
			
				if(distance > maxDistance){
					maxDistance = distance;
				}
				
				distance += 5;
				
				//if (distance < positiveThreshold) {
				//	distance = -1*distance;
				//}
				
				matrix.set(tempindex1, tempindex2,distance);
				
			}
		}
		//System.out.println("ObjectDistanceMatrix: MaxDistance: " + maxDistance);
		//System.out.println(meandistance/(uniqueTasks.size()*uniqueTasks.size()));
		//System.out.println(idmapping.toString());
		//System.out.println(matrix.toString());
		//System.out.println(idmapping.keySet().toString());
		//System.out.println(idmapping.values().toString());
		
	}
	
	public String toString(){
		return matrix.toString();
	}

	@Override
	public float getDistance(int taskId1, int taskId2) {
		//System.out.println("Taskid1: " + taskId1 + " Taskid2: " + taskId2 + " Idmapping1: " + idmapping.get(taskId1) + " Idmapping2: " + idmapping.get(taskId2));
		return matrix.get(idmapping.get(taskId1),idmapping.get(taskId2));
	}

}

