package de.ugoe.cs.eventbench.windows.commands;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.List;

import de.ugoe.cs.eventbench.windows.LogPreprocessor;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

public class CMDconvertToXml implements Command {

	@Override
	public void help() {
		Console.println("Usage: convertToXml <sourceFile> <targetFile> {<base64>}");
	}

	@Override
	public void run(List<Object> parameters) {
		if( parameters.size() < 2 ) {
			throw new InvalidParameterException();
		}
		String source = (String) parameters.get(0);
		String target = (String) parameters.get(1);
		boolean base64 = false;
		if( parameters.size() == 3 ) {
			base64 = Boolean.parseBoolean((String) parameters.get(2));
		}
		
		try {
			new LogPreprocessor(base64).convertToXml(source, target);
		} catch (FileNotFoundException e) {
			Console.println(e.getMessage());
		} catch (IOException e) {
			Console.println(e.getMessage());
		}
		
	}

}
