package de.ugoe.cs.autoquest.tasktrees.alignment.substitution;

public class TriangleMatrix {
	
	private double[] matrix;
	private int size;
	
	
	
	public TriangleMatrix(int size) {
		this.size = size;
		matrix = new double [size*(size+1)/2];
	}
	
	public double get(int first, int second) {
		int row = Math.min(first, second);
		int col = Math.max(first, second);
		return matrix[row*size-(row*(row+1)/2 - (size-col))];
		
	}
	
	public void set(int first, int second, double value) {
		int row = Math.min(first, second);
		int col = Math.max(first, second);
		matrix[row*size-(row*(row+1)/2 - (size-col))] = value;
	}

	public void initialize(double value) {
		for (int i=0; i < matrix.length; i++) {
			matrix[i] = value;
		}
	}
	
	
	public String toString() {
		String result = "";
		for (int i = 0; i < size; i++) {
			for(int j = 0; j< size; j++) {
				if(i<j) {
					if(Double.isInfinite(this.get(i,j))) {
						result = result + " -------";
					}
					else {
						result = result + String.format("%+8.2f",this.get(i,j));
					}
				}
				else {
					result = result + ("        ");
				}
			}
			result = result + "\n";
		}
		return result;
	}
}
