package de.ugoe.cs.autoquest.tasktrees.alignment.matrix;

import de.ugoe.cs.autoquest.tasktrees.alignment.pal.misc.Identifier;


public class UPGMAMatrix extends TriangleMatrix {

	public UPGMAMatrix(int size) {
		super(size);
	}

	public int size() {
		return size;
	}

	public String toString() {
		String result = "";
		for (int i = 0; i < size; i++) {
			result = result + String.format("%8d", i);
		}
		result += "\n";
		
		for (int i = 0; i < size; i++) {
			for(int j = 0; j< size; j++) {
				if(i<j) {
					if(Double.isInfinite(this.get(i,j))) {
						result = result + " -------";
					}
					else {
						result = result + String.format("%+8.2f",this.get(i,j));
					}
				}
				else {
					result = result + ("        ");
				}
			}
			result = result + "   " + i + "\n";
		}
		return result;
	}

	

}
