//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeifc;

import de.ugoe.cs.autoquest.eventcore.Event;

/**
 * <p>
 * the instance of an {@link IEventTask}. The instance refers to the concrete event it represents.
 * </p>
 * 
 * @author Patrick Harms
 */
public interface IEventTaskInstance extends ITaskInstance {

    /**
     * <p>
     * returns the event represented by this event task instance
     * </p>
     * 
     * @return as described
     */
    public Event getEvent();

    /**
     * <p>
     * returns the task related to the instance, i.e. the event task.
     * </p>
     * 
     * @return as described
     */
    public IEventTask getEventTask();

    /**
     * <p>
     * clones this task instance by creating exact clones of itself. The referred task and event
     * stay untouched
     * </p>
     * 
     * @return a clone of the task instance
     */
    public IEventTaskInstance clone();
    
}
