//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

import org.junit.*;

import static org.junit.Assert.*;
import static org.mockito.Mockito.*;

import de.ugoe.cs.autoquest.SequenceInstanceOf;
import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.autoquest.eventcore.IEventType;


/**
 * The class <code>SequenceInstanceOfTest</code> contains tests for the
 * class <code>{@link SequenceInstanceOf}</code>.
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class SequenceInstanceOfTest {
	
	@Test
	public void TestIsCollectionOfSequences_1() throws Exception {
		Collection<List<Event>> sequences = new LinkedList<List<Event>>();
		List<Event> sequence1 = new ArrayList<Event>();
		sequence1.add(new Event(mock(IEventType.class)));
		sequences.add(sequence1);
		
		boolean result = SequenceInstanceOf.isCollectionOfSequences(sequences);
		assertTrue(result);
	}
	
	@Test
	public void TestIsCollectionOfSequences_2() throws Exception {
		Collection<List<Event>> sequences = new LinkedList<List<Event>>();
		List<Event> sequence1 = new ArrayList<Event>();
		sequences.add(sequence1);
		
		boolean result = SequenceInstanceOf.isCollectionOfSequences(sequences);
		assertFalse(result);
	}
	
	@Test
	public void TestIsCollectionOfSequences_3() throws Exception {
		Collection<List<Event>> sequences = new LinkedList<List<Event>>();
		
		boolean result = SequenceInstanceOf.isCollectionOfSequences(sequences);
		assertFalse(result);
	}
	
	@Test
	public void TestIsCollectionOfSequences_4() throws Exception {
		boolean result = SequenceInstanceOf.isCollectionOfSequences(null);
		assertFalse(result);
	}
	
	@Test
	public void TestIsCollectionOfSequences_5() throws Exception {
		boolean result = SequenceInstanceOf.isCollectionOfSequences(new Object());
		assertFalse(result);
	}
	
	@Test
	public void TestIsEventSequence_1() throws Exception {
		List<Event> sequence = new ArrayList<Event>();
		sequence.add(new Event(mock(IEventType.class)));
		
		boolean result = SequenceInstanceOf.isEventSequence(sequence);
		assertTrue(result);
	}
	
	@Test
	public void TestIsEventSequence_2() throws Exception {
		List<Event> sequence = new ArrayList<Event>();
		
		boolean result = SequenceInstanceOf.isEventSequence(sequence);
		assertFalse(result);
	}
	
	@Test
	public void TestIsEventSequence_3() throws Exception {
		boolean result = SequenceInstanceOf.isEventSequence(null);
		assertFalse(result);
	}
	
	@Test
	public void TestIsEventSequence_4() throws Exception {
		boolean result = SequenceInstanceOf.isEventSequence(new Object());
		assertFalse(result);
	}
	
	
	
	public static void main(String[] args) {
		new org.junit.runner.JUnitCore().run(SequenceInstanceOfTest.class);
	}
}
