// Identifier.java
//
// (c) 1999-2000 PAL Development Core Team
//
// This package may be distributed under the
// terms of the Lesser GNU General Public License (LGPL)

package de.ugoe.cs.autoquest.tasktrees.alignment.pal.misc;

import java.io.Serializable;
import de.ugoe.cs.autoquest.tasktrees.alignment.pal.util.Comparable;

/**
 * An identifier for some sampled data. This will most often be
 * for example, the accession number of a DNA sequence, or the
 * taxonomic name that the sequence represents, et cetera.
 *
 * @version $Id: Identifier.java,v 1.6 2001/12/02 22:32:18 matt Exp $
 *
 * @author Alexei Drummond
 */


public class Identifier implements
					 Comparable, Nameable {

	private String name = null;

	
	public static Identifier ANONYMOUS = new Identifier("");

		public Identifier() {}

		public Identifier(String name) {
	setName(name);
		}

		public String toString() {
	return getName();
		}

		// implements Comparable interface

		public int compareTo(Object c) {

	return getName().compareTo(((Identifier)c).getName());
		}

		public boolean equals(Object c) {

	if (c instanceof Identifier) {
			return getName().equals(((Identifier)c).getName());
	} else return false;
		}

		// implements Nameable interface

		public String getName() {
	return name;
		}

		public void setName(String s) {
	name = s;
		}
	/**
	 * Translates an array of identifiers into an array of strings
	 */
	public final static String[] getNames(Identifier[] ids) {
		String[] names = new String[ids.length];
		for(int i = 0 ; i < names.length ; i++) {
			names[i] = ids[i].getName();
		}
		return names;
	}
	/**
	 * Translates an array of identifiers into an array of strings, with optional removal of particular identifier
	 * @param toIgnoreIndex the index of an idetifier to ignore, if <0 no element is ignored
	 */
	public final static String[] getNames(Identifier[] ids, int toIgnore) {
		if(toIgnore<0||toIgnore>=ids.length) {
			return getNames(ids);
		}
		String[] names = new String[ids.length-1];
		int index = 0;
		for(int i = 0 ; i < names.length ; i++) {
			if(i!=toIgnore) {
				names[index] = ids[i].getName();
				index++;
			}
		}
		return names;
	}

}

