// LableMapping.java
//
// (c) 1999-2001 PAL Development Core Team
//
// This package may be distributed under the
// terms of the Lesser GNU General Public License (LGPL)

package de.ugoe.cs.autoquest.tasktrees.alignment.pal.misc;

/**
 * Title:        LabelMapping
 * Description:  Allows for the substitution of one label for another
 * @author			 Matthew Goode
 * @version 1.0
 */
import java.util.*;
public class LabelMapping implements java.io.Serializable {
	Hashtable mappings_ = new Hashtable();
	public LabelMapping() { }

	public void addMapping(String id, String label) {
		mappings_.put(id,label);
	}
	public void addMapping(Identifier id, String label) {
		if(id!=null&&id.getName()!=null) {
			mappings_.put(id.getName(),label);
		}
	}
	/**
	 * @param names Names
	 * @param colours associated colours
	 * @note assumes parallel arrays
	 */
	public void addMappings(String[] ids, String[] labels) {
		for(int i = 0 ; i < ids.length ; i++) {
			mappings_.put(ids[i],labels[i]);
		}
	}

	public String getLabel(String id, String defaultLabel) {
		if(id==null||!mappings_.containsKey(id)) {
			return defaultLabel;
		}
		return mappings_.get(id).toString();
	}
	public String getLabel(Identifier id, String defaultLabel) {
		if(id==null) {
			return defaultLabel;
		}
		return getLabel(id.getName(),defaultLabel);
	}
	public String getLabel(Identifier id) {
		return getLabel(id.getName(),id.getName());
	}
	public Identifier getLabelIdentifier(Identifier id) {
		if(id==null) {
			return null;
		}
		return new Identifier(getLabel(id.getName(),id.getName()));
	}
}