// Utils.java
//
// (c) 1999-2001 PAL Development Core Team
//
// This package may be distributed under the
// terms of the Lesser GNU General Public License (LGPL)

package de.ugoe.cs.autoquest.tasktrees.alignment.pal.misc;



/**
 * Provides some miscellaneous methods.
 *
 * @version $Id: Utils.java,v 1.9 2001/11/20 19:58:45 alexi Exp $
 *
 * @author Matthew Goode
 */
public class Utils {

	/** Clones an array of doubles
		* @return null if input is null, otherwise return complete copy.
		*/
	public static final double[] getCopy(double[] array) {

		if(array == null) {
			return null;
		}
		double[] copy = new double[array.length];
		System.arraycopy(array,0,copy,0,array.length);
		return copy;
	}
	
	/** 
	 * Clones an array of doubles
	 * @return null if input is null, otherwise return complete copy.
	 */
	public static final double[][] getCopy(double[][] array) {

		if(array == null) {
			return null;
		}
		double[][] copy = new double[array.length][];
		for(int i = 0 ; i < copy.length ; i++) {
			copy[i] = new double[array[i].length];
			System.arraycopy(array[i],0,copy[i],0,array[i].length);
		}
		return copy;
	}

	/** 
	 * Clones an array of ints
	 * @return null if input is null, otherwise return complete copy.
	 */
	public static final int[] getCopy(int[] array) {
		if(array == null) {
			return null;
		}
		int[] copy = new int[array.length];
		System.arraycopy(array,0,copy,0,array.length);
		return copy;
	}

	/** Copies all of source into dest - assumes dest to be large enough */
	public static final void copy(double[][] source, double[][] dest) {
		for(int i = 0 ; i < source.length ; i++) {
			System.arraycopy(source[i],0,dest[i],0,source[i].length);
		}
	}

	/** 
	 * A simple toString method for an array of doubles.
	 * No fancy formating.
	 * Puts spaces between each value
	 */
	public static final String toString(double[] array) {
		StringBuffer sb = new StringBuffer(array.length*7);
		for(int i = 0 ; i < array.length ; i++) {
			sb.append(array[i]);
			sb.append(' ');
		}
		return sb.toString();
	}
	/** 
	 * A simple toString method for an array of ints.
	 * No fancy formating.
	 * Puts spaces between each value
	 */
	public static final String toString(int[] array) {
		StringBuffer sb = new StringBuffer(array.length*7);
		for(int i = 0 ; i < array.length ; i++) {
			sb.append(array[i]);
			sb.append(' ');
		}
		return sb.toString();
	}
		
	/** 
	 * A simple toString method for an array of doubles.
	 * No fancy formating.
	 * Puts spaces between each value
	 */
	public static final String toString(double[][] array) {
		String ss = "";
		for(int i = 0 ; i < array.length ; i++) {
			ss+= i+":"+toString(array[i])+'\n';
		}
		return ss;
	}
}



