package de.ugoe.cs.autoquest.tasktrees.alignment.matrix;


import de.ugoe.cs.autoquest.tasktrees.alignment.algorithms.SmithWatermanRepeated;

public class BinaryAlignmentStorage {

    private SmithWatermanRepeated[][] alignments;
    UPGMAMatrix sequenceDistances;
   
    public BinaryAlignmentStorage(int size) {
    	alignments = new SmithWatermanRepeated[size][size];
    	sequenceDistances = new UPGMAMatrix(size);
    	sequenceDistances.initialize(Double.POSITIVE_INFINITY);
    }
    
    public void set(int i,int j,SmithWatermanRepeated sw) {
    	alignments[i][j] = sw;
    }
    
    public SmithWatermanRepeated get(int i,int j) {
    	return alignments[i][j];
    }
    
    public void setDistance(int i,int j,double distance) {
    	sequenceDistances.set(i, j, distance);
    }
    
    public double getDistance(int i,int j) {
    	return sequenceDistances.get(i,j);
    }
    
    public UPGMAMatrix getDistanceMatrix() {
    	return sequenceDistances;
    }
}

