package de.ugoe.cs.autoquest.plugin.usability2.rules.results;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;

public class DefaultMatch implements IMatch {

    private final static Map<String, ITask> EMPTY_MAP = Collections.emptyMap(); 
    
    final ITask task;
    Map<String, ITask> map;
    
    public DefaultMatch(ITask task, String label, Map<String, ITask> map) {
        if(map == null)
            map = EMPTY_MAP;
        map = new HashMap<String, ITask>(map);
        if(label != null)
            map.put(label, task);
        this.map = map;
        this.task = task;
    }

    public DefaultMatch(ITask task, Map<String, ITask> map) {
        this(task, null, map);
    }

    public DefaultMatch(ITask task, String label) {
        this(task, label, EMPTY_MAP);
    }

    public DefaultMatch(ITask task) {
        this(task, null, EMPTY_MAP);
    }

    
    @Override
    public ITask getTask() {
        return task;
    }

    @Override
    public Map<String, ITask> getLabeledResults() {
        return Collections.unmodifiableMap(map);
    }

}
