package de.ugoe.cs.eventbench.web.data;

import java.util.ArrayList;
import java.util.List;

import de.ugoe.cs.eventbench.data.IReplayable;

public class WebRequest implements IReplayable {

	/**
	 * Id for object serialization.
	 */
	private static final long serialVersionUID = 1L;

	List<String> postVars;
	List<String> getVars;
	
	String targetUri;
	
	public WebRequest(String uri, List<String> postVars, List<String> getVars) {
		targetUri = uri;
		this.postVars = new ArrayList<String>(postVars); // defensive copy
		this.getVars = new ArrayList<String>(getVars);
	}
	
	@Override
	public String getReplay() {
		// TODO implement method
		return null;
	}

	@Override
	public String getTarget() {
		// TODO implement method
		return null;
	}
	
	@Override
	public boolean equals(Object other) {
		if( this==other ) {
			return true;
		}
		if( other instanceof WebRequest ) {
			return targetUri.equals(((WebRequest) other).targetUri) && postVars.equals(((WebRequest) other).postVars);
		}
		return false;
	}
	
	@Override
	public int hashCode() {
		int multiplier = 17;
		int hash = 42;

		hash = multiplier * hash + targetUri.hashCode();
		hash = multiplier * hash + postVars.hashCode();

		return hash;
	}

}
