package de.ugoe.cs.eventbench.windows.commands;

import java.security.InvalidParameterException;
import java.util.List;

import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.eventbench.windows.LogParser;
import de.ugoe.cs.eventbench.windows.WindowsEvent;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

public class CMDparseXML implements Command {

	@Override
	public void help() {
		Console.println("Usage: parseXML <filename> {<countMessageOccurences}");
	}

	@Override
	public void run(List<Object> parameters) {
		String filename;
		boolean countMessageOccurences = false;
		
		try {
			filename = (String) parameters.get(0);
			if( parameters.size()==2 ) {
				countMessageOccurences = Boolean.parseBoolean((String) parameters.get(1));
			}
		} catch (Exception e) {
			throw new InvalidParameterException();
		}
		
		LogParser parser = new LogParser(countMessageOccurences);
		parser.parseFile(filename);
		
		List<List<WindowsEvent>> sequences = parser.getSequences();
		
		if( GlobalDataContainer.getInstance().addData("sequences", sequences ) ) {
			Console.traceln("Old data \"" + "sequences" + "\" overwritten");
		}	
	}

}
