//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.eventcore.guimodel;

/**
 * <p>
 * Common interface for GUI element factories. 
 * </p>
 * 
 * @version 1.0
 * @author Patrick Harms
 */
public interface IGUIElementFactory {

    /**
     * <p>
     * Instantiates a new {@link IGUIElement} from a given specification.
     * </p>
     * 
     * @param specification
     *            specification of the new GUI element
     * @param parent
     *            parent of the new GUI element
     * @return created GUI element
     * @throws GUIModelConfigurationException
     *             thrown if there is a problem during the creation of the GUI element
     */
    public IGUIElement instantiateGUIElement(IGUIElementSpec specification, IGUIElement parent)
        throws GUIModelConfigurationException;
    
}
