package de.ugoe.cs.autoquest.tasktrees.alignment.algorithms;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

import de.ugoe.cs.autoquest.tasktrees.alignment.matrix.SubstitutionMatrix;

public class AlignmentAlgorithmFactory {
	
	public static void setDefaultAlgorithm(String algorithmname) {
		//TODO: check for valid algorihm class names here
		algorithmclass = algorithmname;
	}
	
	private static String algorithmclass = "de.ugoe.cs.autoquest.tasktrees.alignment.algorithms.SmithWatermanRepeated";
	
	
	
	public static AlignmentAlgorithm create() {
		Class<?> newclass;
		Object object = null;
		try {
			 newclass = Class.forName(algorithmclass);
			 object = newclass.newInstance();
			
		} catch (ClassNotFoundException | SecurityException | InstantiationException | IllegalAccessException | IllegalArgumentException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		//return new SmithWaterman(input1,input2,submat,threshold);
		//return new NeedlemanWunsch(input1,input2,submat,threshold);
		//return new SmithWatermanRepeated(input1,input2,submat,threshold);
		return (AlignmentAlgorithm) object;
	}
}
