package de.ugoe.cs.autoquest.tasktrees.alignment.matrix;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;

import de.ugoe.cs.autoquest.tasktrees.alignment.algorithms.AlignmentAlgorithm;
import de.ugoe.cs.autoquest.tasktrees.alignment.algorithms.AlignmentAlgorithmFactory;
import de.ugoe.cs.autoquest.tasktrees.alignment.algorithms.NumberSequence;
import de.ugoe.cs.util.console.Console;

public class PairwiseAlignmentGenerator {

	public static PairwiseAlignmentStorage generate(
			ArrayList<NumberSequence> numberseqs,
			ObjectDistanceSubstitionMatrix submat) {
		PairwiseAlignmentStorage alignments = new PairwiseAlignmentStorage(
				numberseqs.size(), numberseqs.size());

		for (int i = 0; i < numberseqs.size(); i++) {
			NumberSequence ns1 = numberseqs.get(i);
			for (int j = 0; j < numberseqs.size(); j++) {
				NumberSequence ns2 = numberseqs.get(j);

				if (i != j) {
					Console.traceln(Level.FINEST,"Aligning sequence " + i + " with sequence " + j);
					int smithWatermanThreshold = 10;
					AlignmentAlgorithm aa = AlignmentAlgorithmFactory.create();
					aa.align(ns1.getSequence(), ns2.getSequence(), submat,
							smithWatermanThreshold);
					alignments.set(i, j, aa);

					AlignmentAlgorithm sameSequence1 = AlignmentAlgorithmFactory
							.create();
					sameSequence1.align(ns1.getSequence(), ns1.getSequence(),
							submat, smithWatermanThreshold);
					AlignmentAlgorithm sameSequence2 = AlignmentAlgorithmFactory
							.create();
					sameSequence2.align(ns2.getSequence(), ns2.getSequence(),
							submat, smithWatermanThreshold);
					AlignmentAlgorithm randomSequence = AlignmentAlgorithmFactory
							.create();
					randomSequence.align(ns1.shuffle().getSequence(), ns2
							.shuffle().getSequence(), submat,
							smithWatermanThreshold);

					// Score of the aligmnment
					double score = alignments.get(i, j).getAlignmentScore();

					
					// Scores of the sequence being aligned to itself (maximum
					// score)
					double sSelf1 = sameSequence1.getAlignmentScore();
					double sSelf2 = sameSequence2.getAlignmentScore();
					// Score of sequences shuffled before aligned
					double sRand = randomSequence.getAlignmentScore();

					double sMax = (sSelf1 + sSelf2) / 2;
					double sEff = (score - sRand) / (sMax - sRand);
					if (sEff < 0) {
						sEff = 0;
					}
					double distance = -Math.log(sEff);

					if (!Double.isInfinite(distance) && !Double.isNaN(distance)) {
						if (distance < alignments.getDistance(i, j)) {
							alignments.setDistance(i, j, distance);
						}
					}
				}
			}
		}
		return alignments;
	}
}
