package de.ugoe.cs.autoquest.tasktrees.alignment.algorithms;

import java.util.ArrayList;
import java.util.Random;

public class NumberSequence {
	private int[] sequence;
	private int signature;

	public NumberSequence(int size) {

		sequence = new int[size];
	}

	public int[] getSequence() {
		return sequence;
	}

	public void setSequence(int[] sequence) {
		this.sequence = sequence;
	}

	public int getSignature() {
		return signature;
	}

	public void setSignature(int signature) {
		this.signature = signature;
	}

	public void printSequence() {
		for (int i = 0; i < sequence.length; i++) {
			System.out.format("%5d", sequence[i]);
		}
		System.out.println();
	}

	public NumberSequence shuffle() {
		NumberSequence result = new NumberSequence(sequence.length);
		result.setSequence(this.sequence);
		Random rgen = new Random();

		for (int i = 0; i < result.sequence.length; i++) {
			int randomPosition = rgen.nextInt(result.sequence.length);
			int temp = result.sequence[i];
			result.sequence[i] = result.sequence[randomPosition];
			result.sequence[randomPosition] = temp;
		}
		return result;

	}

	// TODO: This can be done faster
	public int containsPattern(ArrayList<NumberSequence> pattern) {
		int i = 0;
		int count = 0;
		int[] pat1 = pattern.get(0).getSequence();
		int[] pat2 = pattern.get(1).getSequence();
		notmatched: while (i < sequence.length - pat1.length) {
			if (sequence[i] == pat1[0] || sequence[i] == pat2[0]) {
				for (int j = 0; j < pat1.length; j++) {
					if (sequence[i + j] != pat1[j]
							&& sequence[i + j] != pat2[j]) {
						continue notmatched;
					}
				}
				count++;
			}
			i++;
		}
		return count;
	}

	public int size() {
		return sequence.length;
	}
}
