package de.ugoe.cs.autoquest.tasktrees.alignment.algorithms;

import java.util.ArrayList;

import de.ugoe.cs.autoquest.tasktrees.alignment.matrix.SubstitutionMatrix;

public interface AlignmentAlgorithm {
	
	/**
	 * Get the alignment score between the two input strings.
	 */
	public abstract double getAlignmentScore();

	public abstract ArrayList<NumberSequence> getAlignment();

	public abstract void printDPMatrix();

	public abstract void printAlignment();

	public abstract ArrayList<Match> getMatches();

	void align(NumberSequence input1, NumberSequence input2,
			SubstitutionMatrix submat, float threshold);

}