package de.ugoe.cs.autoquest.tasktrees.alignment.algorithms;

import java.util.ArrayList;
import java.util.Random;

public class NumberSequence {
	private int[] sequence;
	private int id;

	public ArrayList<Match> getMatches() {
		return matches;
	}


	public void setMatches(ArrayList<Match> matches) {
		this.matches = matches;
	}
	
	public void addMatches(ArrayList<Match> matches) {
		this.matches.addAll(matches);
	}

	private ArrayList<Match> matches;

	public NumberSequence(int size) {

		sequence = new int[size];
	}
	
	public int[] getSequence() {
		return sequence;
	}

	public void setSequence(int[] sequence) {
		this.sequence = sequence;
	}

	

	public void printSequence() {
		for (int i = 0; i < sequence.length; i++) {
			System.out.format("%5d", sequence[i]);
		}
		System.out.println();
	}

	public NumberSequence shuffle() {
		NumberSequence result = new NumberSequence(sequence.length);
		result.setId(getId());
		result.setSequence(this.sequence);
		Random rgen = new Random();

		for (int i = 0; i < result.sequence.length; i++) {
			int randomPosition = rgen.nextInt(result.sequence.length);
			int temp = result.sequence[i];
			result.sequence[i] = result.sequence[randomPosition];
			result.sequence[randomPosition] = temp;
		}
		return result;

	}


	public int containsPattern(Match pattern) {
		int i = 0;
		int count = 0;
		int[] pat1 = pattern.getFirstSequence().getSequence();
		int[] pat2 = pattern.getSecondSequence().getSequence();
		notmatched: while (i < sequence.length - pat1.length) {
			if (sequence[i] == pat1[0] || sequence[i] == pat2[0]) {
				int ipat1 =0;
				int ipat2 =0;
				while(ipat1 < pat1.length && ipat2<pat2.length) {
					if(pat1[ipat1]==-1) {
						ipat1++;
						continue;
					}
					if(pat2[ipat2]==-1) {
						ipat2++;
						continue;
					}
					if (sequence[i + ipat1] != pat1[ipat1]
							&& sequence[i + ipat2] != pat2[ipat2]) {
						i++;
						continue notmatched;
					}
					ipat1++;
					ipat2++;
				}
				count++;
			}
			i++;
		}
		return count;
	}
	
	//Returns the number of times event occurs in this sequence
	public int eventCount(int event) {
		int count = 0;
		for(int i=0;i<sequence.length;i++) {
			if(sequence[i] == event) {
				count++;
			}
		}
		return count;
	}

	public int size() {
		return sequence.length;
	}


	public int getId() {
		return id;
	}


	public void setId(int id) {
		this.id = id;
	}
}
