package de.ugoe.cs.autoquest.plugin.usability2.rules.operator;

import de.ugoe.cs.autoquest.plugin.usability2.rules.results.IResult;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;

public abstract class MarkingFilter implements IFilter {

    private static final IResultTransformer IDENTITY_TRANSFORMER = new IResultTransformer() {
        @Override
        public IResult transform(IResult result, IFilter filter, ITask task) {
            return result;
        }
    };

    private final IFilter filter;
    private final IResultTransformer transformer;
    
    public MarkingFilter(IFilter marked) {
        this(marked, IDENTITY_TRANSFORMER);
    }

    public MarkingFilter(IFilter marked, IResultTransformer transformer) {
        this.filter = marked;
        if(transformer == null)
            this.transformer = IDENTITY_TRANSFORMER;
        else
            this.transformer = transformer;
    }
    
    @Override
    public IResult match(ITask task) {
        return transformer.transform(match(task, filter), filter, task);
    }
    
    protected abstract IResult match(ITask task, IFilter filter);
}
