// Tree.java
//
// (c) 1999-2001 PAL Development Core Team
//
// This package may be distributed under the
// terms of the Lesser GNU General Public License (LGPL)


package de.ugoe.cs.autoquest.tasktrees.alignment.pal.tree;



/**
 * Interface for a phylogenetic or genealogical tree.
 *
 * @version $Id: Tree.java,v 1.17 2001/11/20 03:44:49 alexi Exp $
 *
 * @author Alexei Drummond
 */
public interface Tree {

	/**
	 * @return the root node of this tree.
	 */
	Node getRoot();

	/**
	 * This method constructs a tree from the given root node.
	 * @param root the root node of the tree to construct.
	 */
	void setRoot(Node root);

	/**
	 * @return a count of the number of external nodes (tips) in this
	 * tree.
	 */
	int getExternalNodeCount();
	
	/**
	 * @return a count of the number of internal nodes (and hence clades)
	 * in this tree.
	 */
	int getInternalNodeCount();

	/**
	 * @return the ith external node in the tree.
	 */
	Node getExternalNode(int i);
	
	/**
	 * @return the ith internal node in the tree.
	 */
	Node getInternalNode(int i);

	/**
	 * This method is called to ensure that the calls to other methods
	 * in this interface are valid.
	 */
	void createNodeList();


}
