package de.ugoe.cs.autoquest.tasktrees.alignment.algorithms;

import static org.junit.Assert.*;

import org.junit.Test;

public class NumberSequenceTest {

	@Test
	public void testContainsPattern() {
		int[] seq = new int[10];
		for (int i=0; i<10; i++) {
			seq[i] = i;
		}
		
		int[] pat1 = new int[]{2,3,4};
		int[] pat2 = new int[]{2,3,4};
		
		int[] pat3 = new int[]{5,-1,7};
		int[] pat4 = new int[]{1,2,3};
		
		int[] pat5 = new int[]{-1,-1,-1};
		int[] pat6 = new int[]{10,11,12};
		
		
		NumberSequence ns = new NumberSequence(10);
		ns.setSequence(seq);
		
		NumberSequence firstpattern = new NumberSequence(3);
		NumberSequence secondpattern = new NumberSequence(3);
		firstpattern.setSequence(pat1);
		secondpattern.setSequence(pat2);
		
		Match pattern = new Match();
		pattern.setFirstSequence(firstpattern);
		pattern.setSecondSequence(secondpattern);
		
		assertEquals(Integer.valueOf(2),ns.containsPattern(pattern).get(0));
		
		firstpattern.setSequence(pat3);
		secondpattern.setSequence(pat4);
		
		assertEquals(Integer.valueOf(1),ns.containsPattern(pattern).get(0));
		assertEquals(Integer.valueOf(5),ns.containsPattern(pattern).get(1));
	
		firstpattern.setSequence(pat5);
		secondpattern.setSequence(pat5);
		
		assertEquals(0,ns.containsPattern(pattern).size());
		
		firstpattern.setSequence(pat6);
		secondpattern.setSequence(pat6);
		
		assertEquals(0,ns.containsPattern(pattern).size());
	}

	@Test
	public void testEventCount() {
		int[] seq = new int[10];
		for (int i=0; i<10; i++) {
			seq[i] = i;
		}
		NumberSequence ns = new NumberSequence(10);
		ns.setSequence(seq);
		
		int[] pat2 = new int[]{-1,-1,-1};
		int[] pat3 = new int[]{0,1,2,3,0,2};
		
		assertEquals(1,ns.eventCount(5));
		
		ns.setSequence(pat2);
		assertEquals(3,ns.eventCount(-1));
		
		ns.setSequence(pat3);
		assertEquals(2,ns.eventCount(0));
		assertEquals(2,ns.eventCount(2));
		assertEquals(0,ns.eventCount(5));
	}

	@Test
	public void testEqualsNumberSequence() {
		int[] seq1 = new int[10];
		for (int i=0; i<10; i++) {
			seq1[i] = i;
		}
		NumberSequence ns1 = new NumberSequence(10);
		ns1.setSequence(seq1);
		
		int[] seq2 = new int[10];
		for (int i=0; i<10; i++) {
			seq2[i] = i;
		}
		NumberSequence ns2 = new NumberSequence(10);
		ns2.setSequence(seq2);
		
		int[] seq3 = new int[10];
		for (int i=0; i<10; i++) {
			seq3[i] = 2*i;
		}
		NumberSequence ns3 = new NumberSequence(10);
		ns3.setSequence(seq3);
		
		assertTrue(ns1.equals(ns2));
		assertFalse(ns1.equals(ns3));
		assertFalse(ns2.equals(ns3));
		
	}

}
