/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.AuralAttributes;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.Bounds;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Leaf;
import javax.media.j3d.Node;
import javax.media.j3d.NodeReferenceTable;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.SoundscapeRetained;

public class Soundscape
extends Leaf {
    public static final int ALLOW_APPLICATION_BOUNDS_READ = 12;
    public static final int ALLOW_APPLICATION_BOUNDS_WRITE = 13;
    public static final int ALLOW_ATTRIBUTES_READ = 14;
    public static final int ALLOW_ATTRIBUTES_WRITE = 15;

    public Soundscape() {
    }

    public Soundscape(Bounds bounds, AuralAttributes auralAttributes) {
        ((SoundscapeRetained)this.retained).setApplicationBounds(bounds);
        ((SoundscapeRetained)this.retained).setAuralAttributes(auralAttributes);
    }

    void createRetained() {
        this.retained = new SoundscapeRetained();
        this.retained.setSource(this);
    }

    public void setApplicationBounds(Bounds bounds) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Soundscape0"));
        }
        ((SoundscapeRetained)this.retained).setApplicationBounds(bounds);
    }

    public Bounds getApplicationBounds() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Soundscape1"));
        }
        return ((SoundscapeRetained)this.retained).getApplicationBounds();
    }

    public void setApplicationBoundingLeaf(BoundingLeaf boundingLeaf) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Soundscape0"));
        }
        ((SoundscapeRetained)this.retained).setApplicationBoundingLeaf(boundingLeaf);
    }

    public BoundingLeaf getApplicationBoundingLeaf() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Soundscape1"));
        }
        return ((SoundscapeRetained)this.retained).getApplicationBoundingLeaf();
    }

    public void setAuralAttributes(AuralAttributes auralAttributes) {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Soundscape4"));
        }
        ((SoundscapeRetained)this.retained).setAuralAttributes(auralAttributes);
    }

    public AuralAttributes getAuralAttributes() {
        if (this.isLiveOrCompiled() && !this.getCapability(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Soundscape5"));
        }
        return ((SoundscapeRetained)this.retained).getAuralAttributes();
    }

    public Node cloneNode(boolean bl) {
        Soundscape soundscape = new Soundscape();
        soundscape.duplicateNode(this, bl);
        return soundscape;
    }

    public void duplicateNode(Node node, boolean bl) {
        this.checkDuplicateNode(node, bl);
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        SoundscapeRetained soundscapeRetained = (SoundscapeRetained)node.retained;
        SoundscapeRetained soundscapeRetained2 = (SoundscapeRetained)this.retained;
        soundscapeRetained2.setApplicationBounds(soundscapeRetained.getApplicationBounds());
        soundscapeRetained2.setAuralAttributes((AuralAttributes)this.getNodeComponent(soundscapeRetained.getAuralAttributes(), bl, node.nodeHashtable));
        soundscapeRetained2.setApplicationBoundingLeaf(soundscapeRetained.getApplicationBoundingLeaf());
    }

    public void updateNodeReferences(NodeReferenceTable nodeReferenceTable) {
        SoundscapeRetained soundscapeRetained = (SoundscapeRetained)this.retained;
        BoundingLeaf boundingLeaf = soundscapeRetained.getApplicationBoundingLeaf();
        if (boundingLeaf != null) {
            SceneGraphObject sceneGraphObject = nodeReferenceTable.getNewObjectReference(boundingLeaf);
            soundscapeRetained.setApplicationBoundingLeaf((BoundingLeaf)sceneGraphObject);
        }
    }
}

