package de.ugoe.cs.eventbench.commands;

import java.util.List;
import java.util.Map.Entry;
import java.util.SortedMap;
import java.util.TreeMap;

import de.ugoe.cs.eventbench.data.Event;
import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

public class CMDsequenceStatistics implements Command {

	@SuppressWarnings("unchecked")
	@Override
	public void run(List<Object> parameters) {
		String sequencesName = "sequences";
		if( parameters.size()==1 ) {
			sequencesName = (String) parameters.get(0);
		}
		
		
		List<List<Event<?>>> sequences = null;
		Object dataObject = GlobalDataContainer.getInstance().getData(sequencesName);
			
		try {
			sequences = (List<List<Event<?>>>) dataObject;
			Console.traceln("Number of Sequences: " + sequences.size());
			SortedMap<Integer,Integer> lengthMap = new TreeMap<Integer, Integer>();
			for( List<Event<?>> sequence : sequences ) {
				Integer currentSize = sequence.size();
				if( lengthMap.containsKey(currentSize) ) {
					lengthMap.put(currentSize, lengthMap.get(currentSize)+1);
				} else {
					lengthMap.put(currentSize, 1);
				}
			}
			for( Entry<Integer, Integer> entry : lengthMap.entrySet() ) {
				Console.traceln("Of length " + entry.getKey() + ": " + entry.getValue());
			}
			
		}
		catch(ClassCastException e) {
			Console.println("Sequences not found");
		}
	}

	@Override
	public void help() {
		Console.println("Usage: sequenceStatistics {<sequencesName>}");
	}

}
