package de.ugoe.cs.autoquest.tasktrees.alignment.algorithms;

import static org.junit.Assert.*;

import org.junit.Test;

import de.ugoe.cs.autoquest.tasktrees.alignment.matrix.DummySubstitutionMatrix;

public class SmithWatermanRepeatedTest {

	@Test
	public void testGetMaxScore() {
		int[] seq1 = new int[]{0,1,2,3,4,5,6,7,8,9};
		int[] seq2 = new int[]{0,1,2,3,4,5,6,7,8,9};
		
		NumberSequence ns1 = new NumberSequence(10);
		NumberSequence ns2 = new NumberSequence(10);
		
		ns1.setSequence(seq1);
		ns2.setSequence(seq2);
		
		DummySubstitutionMatrix submat = new DummySubstitutionMatrix();
		
		AlignmentAlgorithm testalignment1 = AlignmentAlgorithmFactory
				.create();
		
		assertNotNull(testalignment1);
		testalignment1.align(ns1, ns2,submat,5);

		assertTrue(testalignment1.getMaxScore()==10);
	}

	@Test
	public void testGetAlignmentScore() {
		int[] seq1 = new int[]{0,1,2,3,4,5,6,7,8,9};
		int[] seq2 = new int[]{0,1,2,3,4,5,6,7,8,9};
		
		NumberSequence ns1 = new NumberSequence(10);
		NumberSequence ns2 = new NumberSequence(10);
		
		ns1.setSequence(seq1);
		ns2.setSequence(seq2);
		
		DummySubstitutionMatrix submat = new DummySubstitutionMatrix();
		
		AlignmentAlgorithm testalignment1 = AlignmentAlgorithmFactory
				.create();
		assertNotNull(testalignment1);
		testalignment1.align(ns1, ns2,submat,5);
		assertTrue(testalignment1.getAlignmentScore()==5);
	}

	@Test
	public void testGetMatches() {
		int[] seq1 = new int[]{0,1,2,3,4,5,6,7,8,9};
		int[] seq2 = new int[]{3,4,5,6,7};
		
		NumberSequence ns1 = new NumberSequence(10);
		NumberSequence ns2 = new NumberSequence(10);
		
		ns1.setSequence(seq1);
		ns2.setSequence(seq2);
		
		DummySubstitutionMatrix submat = new DummySubstitutionMatrix();
		
		AlignmentAlgorithm testalignment1 = AlignmentAlgorithmFactory
				.create();
		assertNotNull(testalignment1);
		testalignment1.align(ns1, ns2,submat,4);
		testalignment1.printDPMatrix();
		testalignment1.printAlignment();
		
		//testalignment1.getMatches().get(0).getFirstSequence().printSequence();
		//testalignment1.getMatches().get(0).getSecondSequence().printSequence();
		
	}


	//TODO: Need a better substitution matrix to do proper testing
	@Test
	public void testAlign() {
		int[] seq1 = new int[]{0,1,2, 3, 4, 5,6,7,8,9};
		int[] seq2 = new int[]{0,1,2,10,11,12,6,7,8,9};
		
		
		NumberSequence ns1 = new NumberSequence(10);
		NumberSequence ns2 = new NumberSequence(10);
		
		ns1.setSequence(seq1);
		ns2.setSequence(seq2);
		
		DummySubstitutionMatrix submat = new DummySubstitutionMatrix();
		
		AlignmentAlgorithm testalignment1 = AlignmentAlgorithmFactory
				.create();
		assertNotNull(testalignment1);
		testalignment1.align(ns1, ns2,submat,3);
		assertTrue(testalignment1.getAlignmentScore()==1.0);
		
		}

}
