package de.ugoe.cs.autoquest.tasktrees.alignment.algorithms;

import static org.junit.Assert.*;

import org.junit.Test;

public class NumberSequenceTest {

	@Test
	public void testContainsPattern() {
		int[] seq = new int[10];
		for (int i=0; i<10; i++) {
			seq[i] = i;
		}
		
		int[] seq2 = new int[]{1,5,2,6,5,6,4,5,2,6};
		
		int[] seq3 = new int[]{0,0,5,6,0,6,9,10,0,12,13,0,15,16,0,13,0,15,21,13,0,15,21,0,0,0,6,0,9,32,0,5,10,0,6,0,9,32,0,5,43,0,6,0,9,5,6,0,9,43,0,6,0,9,32,0,5,6,6,9,43,0,0,0,0};
	
		
		int[] pat1  = new int[]{2,3,4};
		int[] pat2  = new int[]{2,3,4};
		
		int[] pat3  = new int[]{5,-1,6};
		int[] pat4  = new int[]{1,2,3};
		
		int[] pat5  = new int[]{-1,-1,-1};
		
		int[] pat6  = new int[]{10,11,12};
		
		int[] pat7  = new int[]{8,9,10};
		int[] pat8  = new int[]{7,6,5};
		
		int[] pat9  = new int[]{0};
		int[] pat10 = new int[]{1};
		
		int[] pat11 = new int[]{5,-1,-1,6};
		int[] pat12 = new int[]{10,12,12,12}; 
	
		//int[] pat13 = new int[]{6, 0, 6, 9,-1,-1,10,0};
		//int[] pat14 = new int[]{6,-1, 9,71,32, 5,10,0};
		
		int[] pat13 = new int[]{6, 0, 9, 32,0,5,10,0};
		int[] pat14 = new int[]{6,-1, 71,32,-1,5,10,0};
		
		NumberSequence ns = new NumberSequence(10);
		ns.setSequence(seq);
		
		NumberSequence ns2 = new NumberSequence(seq3.length);
		ns2.setSequence(seq3);
		
		NumberSequence firstpattern = new NumberSequence(3);
		NumberSequence secondpattern = new NumberSequence(3);
		
		NumberSequence thirdpattern = new NumberSequence(4);
		NumberSequence forthpattern= new NumberSequence(4);
		
		NumberSequence fifthpattern = new NumberSequence(pat13.length);
		NumberSequence sixthpattern = new NumberSequence(pat14.length);
		
		firstpattern.setSequence(pat1);
		secondpattern.setSequence(pat2);
		
		thirdpattern.setSequence(pat11);
		forthpattern.setSequence(pat12);
		
		fifthpattern.setSequence(pat13);
		sixthpattern.setSequence(pat14);
		
		
		Match pattern = new Match();
		pattern.setFirstSequence(firstpattern);
		pattern.setSecondSequence(secondpattern);
		
		Match pattern2 = new Match();
		pattern2.setFirstSequence(thirdpattern);
		pattern2.setSecondSequence(forthpattern);
		
		Match pattern3 = new Match();
		pattern3.setFirstSequence(fifthpattern);
		pattern3.setSecondSequence(sixthpattern);
		
		/*
		assertEquals(Integer.valueOf(2),ns.containsPattern(pattern).get(0));
		assertEquals(1,ns.containsPattern(pattern).size());
		
		firstpattern.setSequence(pat3);
		secondpattern.setSequence(pat4);
		
		assertEquals(Integer.valueOf(1),ns.containsPattern(pattern).get(0));
		assertEquals(2,ns.containsPattern(pattern).size());
		assertEquals(Integer.valueOf(5),ns.containsPattern(pattern).get(1));
		
	
		firstpattern.setSequence(pat5);
		secondpattern.setSequence(pat5);
		assertEquals(0,ns.containsPattern(pattern).size());
		
		firstpattern.setSequence(pat6);
		secondpattern.setSequence(pat6);
		assertEquals(0,ns.containsPattern(pattern).size());
		
		firstpattern.setSequence(pat7);
		secondpattern.setSequence(pat8);
		assertEquals(0,ns.containsPattern(pattern).size());
		
		firstpattern.setSequence(pat9);
		secondpattern.setSequence(pat10);
		assertEquals(Integer.valueOf(0),ns.containsPattern(pattern).get(0));
		assertEquals(Integer.valueOf(1),ns.containsPattern(pattern).get(1));
		assertEquals(2,ns.containsPattern(pattern).size());
		
		firstpattern.setSequence(pat11);
		secondpattern.setSequence(pat12);
		assertEquals(1,ns.containsPattern(pattern).size());
		assertEquals(Integer.valueOf(5),ns.containsPattern(pattern).get(0));
		
		ns.setSequence(seq2);
		firstpattern.setSequence(pat3);
		secondpattern.setSequence(pat4);
		assertEquals(3,ns.containsPattern(pattern).size());
		assertEquals(Integer.valueOf(1),ns.containsPattern(pattern).get(0));
		assertEquals(Integer.valueOf(4),ns.containsPattern(pattern).get(1));
		assertEquals(Integer.valueOf(7),ns.containsPattern(pattern).get(2));
		*/
		
		assertEquals(2,ns2.containsPattern(pattern3));
		assertEquals(2,ns2.containsPattern(pattern3).size());
		assertEquals(Integer.valueOf(3),ns.containsPattern(pattern3).get(0));
		assertEquals(Integer.valueOf(26),ns.containsPattern(pattern3).get(1));
		
		
		
	}

	@Test
	public void testEventCount() {
		int[] seq = new int[10];
		for (int i=0; i<10; i++) {
			seq[i] = i;
		}
		NumberSequence ns = new NumberSequence(10);
		ns.setSequence(seq);
		
		int[] pat2 = new int[]{-1,-1,-1};
		int[] pat3 = new int[]{0,1,2,3,0,2};
		
		assertEquals(1,ns.eventCount(5));
		
		ns.setSequence(pat2);
		assertEquals(3,ns.eventCount(-1));
		
		ns.setSequence(pat3);
		assertEquals(2,ns.eventCount(0));
		assertEquals(2,ns.eventCount(2));
		assertEquals(0,ns.eventCount(5));
	}

	@Test
	public void testEqualsNumberSequence() {
		int[] seq1 = new int[10];
		for (int i=0; i<10; i++) {
			seq1[i] = i;
		}
		NumberSequence ns1 = new NumberSequence(10);
		ns1.setSequence(seq1);
		
		int[] seq2 = new int[10];
		for (int i=0; i<10; i++) {
			seq2[i] = i;
		}
		NumberSequence ns2 = new NumberSequence(10);
		ns2.setSequence(seq2);
		
		int[] seq3 = new int[10];
		for (int i=0; i<10; i++) {
			seq3[i] = 2*i;
		}
		NumberSequence ns3 = new NumberSequence(10);
		ns3.setSequence(seq3);
		
		assertTrue(ns1.equals(ns2));
		assertFalse(ns1.equals(ns3));
		assertFalse(ns2.equals(ns3));
		
	}

}
