/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.AWTEvent;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import javax.media.j3d.AudioDevice;
import javax.media.j3d.AudioDevice3D;
import javax.media.j3d.AudioDevice3DL2;
import javax.media.j3d.AuralAttributes;
import javax.media.j3d.AuralAttributesRetained;
import javax.media.j3d.BackgroundSoundRetained;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ConeSoundRetained;
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dStructure;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.MediaContainer;
import javax.media.j3d.MediaContainerRetained;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.PointSoundRetained;
import javax.media.j3d.Sound;
import javax.media.j3d.SoundRetained;
import javax.media.j3d.SoundSchedulerAtom;
import javax.media.j3d.SoundscapeRetained;
import javax.media.j3d.UnorderList;
import javax.media.j3d.UpdateTargets;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.ViewPlatformRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point2f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

class SoundScheduler
extends J3dStructure {
    View view = null;
    boolean ready = false;
    ViewPlatformRetained viewPlatform = null;
    GraphicsContext3D graphicsCtx = null;
    AuralAttributesRetained lastAA = null;
    boolean resetAA = true;
    AudioDevice audioDevice = null;
    AudioDevice3D audioDevice3D = null;
    AudioDevice3DL2 audioDevice3DL2 = null;
    int totalChannels = 0;
    SoundscapeRetained[] intersectedSoundscapes = new SoundscapeRetained[32];
    Bounds[] intersectedRegions = new Bounds[32];
    Bounds region = null;
    ArrayList prioritizedSounds = new ArrayList();
    int nRetainedSounds = -1;
    int nImmedSounds = -1;
    AuralAttributesRetained aaRetained = null;
    boolean transformMsg = false;
    UpdateTargets targets = null;
    AuralAttributesRetained aaImmed = null;
    static final int EAR_POSITIONS_CHANGED = 1;
    static final int EYE_POSITIONS_CHANGED = 2;
    static final int IMAGE_PLATE_TO_VWORLD_CHANGED = 4;
    static final int HEAD_TO_VWORLD_CHANGED = 8;
    static final int LISTENER_CHANGED = 15;
    private int listenerUpdated = 15;
    private boolean positionalSoundUpdated = false;
    private boolean auralAttribsChanged = true;
    private boolean stallThread = false;
    int lastEventReceived = 202;
    static final boolean debugFlag = false;
    static final boolean internalErrors = false;

    SoundScheduler(VirtualUniverse virtualUniverse, View view) {
        super(virtualUniverse, 2);
        this.universe = virtualUniverse;
        this.view = view;
        this.reset(view);
    }

    void processMessages(long l) {
        Object[] objectArray = this.getMessages(l);
        int n = this.getNumMessage();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                J3dMessage j3dMessage = objectArray[n2];
                switch (j3dMessage.type) {
                    case 0: {
                        this.insertNodes(j3dMessage);
                        break;
                    }
                    case 1: {
                        this.removeNodes(j3dMessage);
                        break;
                    }
                    case 38: {
                        this.changeNodeAttrib(j3dMessage);
                        break;
                    }
                    case 45: {
                        this.changeNodeState(j3dMessage);
                        break;
                    }
                    case 23: {
                        this.processBoundingLeafChanged(j3dMessage);
                        break;
                    }
                    case 40: {
                        SoundscapeRetained soundscapeRetained = (SoundscapeRetained)j3dMessage.args[0];
                        if (!this.universe.soundStructure.isSoundscapeScopedToView(soundscapeRetained, this.view)) break;
                        this.auralAttribsChanged = true;
                        this.changeNodeAttrib(j3dMessage);
                        break;
                    }
                    case 39: {
                        this.auralAttribsChanged = true;
                        this.changeNodeAttrib(j3dMessage);
                        break;
                    }
                    case 51: {
                        this.changeNodeAttrib(j3dMessage);
                        break;
                    }
                    case 3: {
                        this.transformMsg = true;
                        this.auralAttribsChanged = true;
                        break;
                    }
                    case 44: {
                        this.processImmediateNodes(j3dMessage.args, l);
                        break;
                    }
                    case 56: {
                        this.processViewSpecificGroupChanged(j3dMessage);
                        break;
                    }
                    case 4: {
                        if (!this.prioritizedSounds.isEmpty()) break;
                        int n3 = this.prioritizeSounds();
                        break;
                    }
                }
                j3dMessage.decRefcount();
                ++n2;
            }
            if (this.transformMsg) {
                this.targets = this.universe.transformStructure.getTargetList();
                this.updateTransformChange(this.targets, l);
                this.transformMsg = false;
                this.targets = null;
            }
            Arrays.fill(objectArray, 0, n, null);
        }
        this.renderChanges();
        long l2 = this.shortestTimeToFinish();
        if (l2 == 0L) {
            VirtualUniverse.mc.sendRunMessage(this.universe, 2);
        } else if (l2 > 0L) {
            VirtualUniverse.mc.sendRunMessage(l2, this.view, 2);
        }
    }

    void insertNodes(J3dMessage j3dMessage) {
        Object object;
        Object[] objectArray = (Object[])j3dMessage.args[0];
        ArrayList arrayList = (ArrayList)j3dMessage.args[3];
        ArrayList arrayList2 = (ArrayList)j3dMessage.args[4];
        int n = 0;
        while (n < objectArray.length) {
            object = objectArray[n];
            if (object instanceof SoundRetained) {
                ++this.nRetainedSounds;
                this.addSound((SoundRetained)object);
            } else if (object instanceof SoundscapeRetained) {
                this.auralAttribsChanged = true;
            } else if (object instanceof AuralAttributesRetained) {
                this.auralAttribsChanged = true;
            } else if (object instanceof ViewPlatformRetained) {
                // empty if block
            }
            ++n;
        }
        if (arrayList != null) {
            int n2 = arrayList.size();
            int n3 = 0;
            while (n3 < n2) {
                object = (NodeRetained)arrayList.get(n3);
                ArrayList arrayList3 = (ArrayList)arrayList2.get(n3);
                if (arrayList3.contains(this.view)) {
                    if (object instanceof SoundRetained) {
                        ++this.nRetainedSounds;
                        this.addSound((SoundRetained)object);
                    } else if (object instanceof SoundscapeRetained) {
                        this.auralAttribsChanged = true;
                    }
                }
                ++n3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSound(SoundRetained soundRetained) {
        if (soundRetained == null) {
            return;
        }
        ArrayList arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            this.addPrioritizedSound(soundRetained);
        }
    }

    void removeNodes(J3dMessage j3dMessage) {
        Object object;
        Object[] objectArray = (Object[])j3dMessage.args[0];
        ArrayList arrayList = (ArrayList)j3dMessage.args[3];
        ArrayList arrayList2 = (ArrayList)j3dMessage.args[4];
        int n = 0;
        while (n < objectArray.length) {
            object = objectArray[n];
            if (object instanceof SoundRetained) {
                SoundSchedulerAtom soundSchedulerAtom = null;
                int n2 = 1;
                while ((soundSchedulerAtom = this.findSoundAtom((SoundRetained)object, n2)) != null) {
                    this.stopSound(soundSchedulerAtom, false);
                    ++n2;
                }
            } else if (object instanceof SoundscapeRetained) {
                this.auralAttribsChanged = true;
            }
            ++n;
        }
        if (arrayList != null) {
            int n3 = arrayList.size();
            int n4 = 0;
            while (n4 < n3) {
                object = (NodeRetained)arrayList.get(n4);
                ArrayList arrayList3 = (ArrayList)arrayList2.get(n4);
                if (arrayList3.contains(this.view)) {
                    if (object instanceof SoundRetained) {
                        SoundSchedulerAtom soundSchedulerAtom = null;
                        int n5 = 1;
                        while ((soundSchedulerAtom = this.findSoundAtom((SoundRetained)object, n5)) != null) {
                            this.stopSound(soundSchedulerAtom, false);
                            ++n5;
                        }
                    } else if (object instanceof SoundscapeRetained) {
                        this.auralAttribsChanged = true;
                    }
                }
                ++n4;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteSound(SoundRetained soundRetained) {
        if (soundRetained != null) {
            return;
        }
        ArrayList arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            if (!this.prioritizedSounds.isEmpty()) {
                int n = this.prioritizedSounds.size();
                int n2 = 0;
                while (n2 < n) {
                    SoundSchedulerAtom soundSchedulerAtom = (SoundSchedulerAtom)this.prioritizedSounds.get(n2);
                    if (soundSchedulerAtom.sound == soundRetained || soundSchedulerAtom.sound.sgSound == soundRetained) {
                        this.stopSound(soundSchedulerAtom, false);
                        this.prioritizedSounds.remove(n2);
                    }
                    ++n2;
                }
            }
        }
    }

    void changeNodeAttrib(J3dMessage j3dMessage) {
        Object object = j3dMessage.args[0];
        Object object2 = j3dMessage.args[1];
        int n = (Integer)object2;
        if (object instanceof SoundRetained && this.universe.soundStructure.isSoundScopedToView(object, this.view)) {
            this.setAttribsDirtyFlag((SoundRetained)object, n);
            if ((n & 0x20) > 0) {
                this.shuffleSound((SoundRetained)object);
            }
            if ((n & 1) > 0) {
                this.loadSound((SoundRetained)object, true);
            }
            if ((n & 0x40) > 0) {
                this.muteSound((SoundRetained)object);
            }
            if ((n & 0x80) > 0) {
                this.pauseSound((SoundRetained)object);
            }
        } else if (object instanceof SoundscapeRetained && this.universe.soundStructure.isSoundscapeScopedToView(object, this.view)) {
            this.auralAttribsChanged = true;
        } else if (object instanceof AuralAttributesRetained) {
            this.auralAttribsChanged = true;
        } else if (object instanceof MediaContainerRetained) {
            int n2 = (Integer)j3dMessage.args[2];
            ArrayList arrayList = (ArrayList)j3dMessage.args[3];
            int n3 = 0;
            while (n3 < n2) {
                SoundRetained soundRetained = (SoundRetained)arrayList.get(n3);
                if (soundRetained != null) {
                    this.loadSound(soundRetained, true);
                }
                ++n3;
            }
        }
    }

    void changeNodeState(J3dMessage j3dMessage) {
        Object object = j3dMessage.args[0];
        Object object2 = j3dMessage.args[1];
        if (object instanceof SoundRetained && this.universe.soundStructure.isSoundScopedToView(object, this.view)) {
            int n = (Integer)object2;
            this.setStateDirtyFlag((SoundRetained)object, n);
            if ((n & 1) > 0) {
                this.loadSound((SoundRetained)object, false);
            }
            if ((n & 0x20) > 0) {
                if (((Boolean)j3dMessage.args[4]).booleanValue()) {
                    this.enableSound((SoundRetained)object);
                } else {
                    SoundRetained soundRetained = (SoundRetained)object;
                    int n2 = this.prioritizedSounds.size() - 1;
                    while (n2 >= 0) {
                        SoundSchedulerAtom soundSchedulerAtom = (SoundSchedulerAtom)this.prioritizedSounds.get(n2);
                        if (soundSchedulerAtom.sound.sgSound == soundRetained) {
                            this.turnOff(soundSchedulerAtom);
                        }
                        --n2;
                    }
                }
            }
        }
    }

    void shuffleSound(SoundRetained soundRetained) {
        this.deleteSound(soundRetained);
        this.addSound(soundRetained);
    }

    void loadSound(SoundRetained soundRetained, boolean bl) {
        SoundSchedulerAtom soundSchedulerAtom = null;
        int n = 1;
        while ((soundSchedulerAtom = this.findSoundAtom(soundRetained, n)) != null) {
            MediaContainer mediaContainer = soundRetained.getSoundData();
            if (bl || soundSchedulerAtom.loadStatus != 2) {
                this.attachSoundData(soundSchedulerAtom, mediaContainer, bl);
            }
            ++n;
        }
    }

    void enableSound(SoundRetained soundRetained) {
        SoundSchedulerAtom soundSchedulerAtom = null;
        int n = 1;
        while ((soundSchedulerAtom = this.findSoundAtom(soundRetained, n)) != null) {
            soundSchedulerAtom.enable(soundRetained.enable);
            ++n;
        }
    }

    void muteSound(SoundRetained soundRetained) {
        SoundSchedulerAtom soundSchedulerAtom = null;
        int n = 1;
        while ((soundSchedulerAtom = this.findSoundAtom(soundRetained, n)) != null) {
            soundSchedulerAtom.mute(soundRetained.mute);
            ++n;
        }
    }

    void pauseSound(SoundRetained soundRetained) {
        SoundSchedulerAtom soundSchedulerAtom = null;
        int n = 1;
        while ((soundSchedulerAtom = this.findSoundAtom(soundRetained, n)) != null) {
            soundSchedulerAtom.pause(soundRetained.pause);
            ++n;
        }
    }

    void processImmediateNodes(Object[] objectArray, long l) {
        Object object = objectArray[0];
        Object object2 = objectArray[1];
        Object object3 = objectArray[2];
        Sound sound = (Sound)object3;
        Sound sound2 = (Sound)object2;
        int n = (Integer)object;
        switch (n) {
            case 15: 
            case 17: {
                this.addSound((SoundRetained)sound2.retained);
                ++this.nImmedSounds;
                break;
            }
            case 16: {
                this.deleteSound((SoundRetained)sound.retained);
                --this.nImmedSounds;
                break;
            }
            case 14: {
                this.deleteSound((SoundRetained)sound.retained);
                this.addSound((SoundRetained)sound2.retained);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTransformChange(UpdateTargets updateTargets, long l) {
        UnorderList unorderList = updateTargets.targetList[3];
        if (unorderList != null) {
            int n = unorderList.size();
            Object[] objectArray = unorderList.toArray(false);
            int n2 = 0;
            while (n2 < n) {
                Object[] objectArray2 = (Object[])objectArray[n2];
                int n3 = 0;
                while (n3 < objectArray2.length) {
                    LeafRetained leafRetained;
                    LeafRetained leafRetained2;
                    if (objectArray2[n3] instanceof ConeSoundRetained && this.universe.soundStructure.isSoundScopedToView(objectArray2[n3], this.view)) {
                        leafRetained2 = (ConeSoundRetained)objectArray2[n3];
                        leafRetained = leafRetained2;
                        synchronized (leafRetained) {
                            ((ConeSoundRetained)leafRetained2).updateTransformChange();
                        }
                        this.setStateDirtyFlag((SoundRetained)objectArray2[n3], 32768);
                    } else if (objectArray2[n3] instanceof PointSoundRetained && this.universe.soundStructure.isSoundScopedToView(objectArray2[n3], this.view)) {
                        leafRetained2 = (PointSoundRetained)objectArray2[n3];
                        leafRetained = leafRetained2;
                        synchronized (leafRetained) {
                            ((PointSoundRetained)leafRetained2).updateTransformChange();
                        }
                        this.setStateDirtyFlag((SoundRetained)objectArray2[n3], 32768);
                    } else if (objectArray2[n3] instanceof SoundscapeRetained && this.universe.soundStructure.isSoundscapeScopedToView(objectArray2[n3], this.view)) {
                        leafRetained2 = (SoundscapeRetained)objectArray2[n3];
                        leafRetained = leafRetained2;
                        synchronized (leafRetained) {
                            ((SoundscapeRetained)leafRetained2).updateTransformChange();
                        }
                    }
                    ++n3;
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTransformedFields(SoundRetained soundRetained) {
        if (soundRetained instanceof ConeSoundRetained && this.universe.soundStructure.isSoundScopedToView(soundRetained, this.view)) {
            ConeSoundRetained coneSoundRetained;
            ConeSoundRetained coneSoundRetained2 = coneSoundRetained = (ConeSoundRetained)soundRetained;
            synchronized (coneSoundRetained2) {
                coneSoundRetained.updateTransformChange();
            }
        }
        if (soundRetained instanceof PointSoundRetained && this.universe.soundStructure.isSoundScopedToView(soundRetained, this.view)) {
            PointSoundRetained pointSoundRetained;
            PointSoundRetained pointSoundRetained2 = pointSoundRetained = (PointSoundRetained)soundRetained;
            synchronized (pointSoundRetained2) {
                pointSoundRetained.updateTransformChange();
            }
        }
    }

    void activate() {
        this.updateThread.active = true;
        VirtualUniverse.mc.sendRunMessage(this.universe, 2);
    }

    void deactivate() {
        if (this.checkState()) {
            this.deactivateAllSounds();
            this.updateThread.active = false;
        }
    }

    boolean checkState() {
        boolean bl = false;
        if (this.stallThread) {
            bl = false;
        }
        if (this.ready) {
            bl = true;
        } else {
            this.reset(this.view);
            bl = this.ready;
        }
        return bl;
    }

    synchronized void reset(View view) {
        int n = 0;
        if (view == null) {
            this.view = null;
            this.viewPlatform = null;
            this.universe = null;
            this.ready = false;
            return;
        }
        this.view = view;
        Object object = this.view.getFirstCanvas();
        if (object != null) {
            this.graphicsCtx = ((Canvas3D)object).getGraphicsContext3D();
        }
        if (view.physicalEnvironment == null) {
            this.audioDevice = null;
            ++n;
        } else if (view.physicalEnvironment.audioDevice == null) {
            if (this.audioDevice == null) {
                ++n;
            }
        } else {
            this.audioDevice = view.physicalEnvironment.audioDevice;
        }
        object = view.getViewPlatform();
        if (object == null || ((ViewPlatform)object).retained == null) {
            this.viewPlatform = null;
            ++n;
        } else {
            this.viewPlatform = (ViewPlatformRetained)((ViewPlatform)object).retained;
            if (this.viewPlatform.universe == null) {
                this.universe = null;
                ++n;
            } else {
                this.universe = this.viewPlatform.universe;
            }
        }
        if (n > 0 || this.audioDevice == null) {
            this.ready = false;
            return;
        }
        this.audioDevice3DL2 = null;
        this.audioDevice3D = null;
        if (this.audioDevice instanceof AudioDevice3DL2) {
            this.audioDevice3DL2 = (AudioDevice3DL2)this.audioDevice;
        }
        if (this.audioDevice instanceof AudioDevice3D) {
            this.audioDevice3D = (AudioDevice3D)this.audioDevice;
            this.audioDevice3D.setView(this.view);
            this.totalChannels = this.audioDevice.getTotalChannels();
        } else {
            this.totalChannels = 0;
        }
        if (this.totalChannels == 0) {
            this.ready = false;
            return;
        }
        this.ready = true;
        this.view.setUserHeadToVworldEnable(true);
    }

    void receiveAWTEvent(AWTEvent aWTEvent) {
        int n = aWTEvent.getID();
        if (this.ready && n == 203) {
            this.lastEventReceived = n;
        } else if (this.ready && this.lastEventReceived == 203 && n == 204) {
            this.lastEventReceived = n;
        }
    }

    void renderChanges() {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        if (!this.checkState()) {
            return;
        }
        n2 = this.prioritizedSounds.size();
        if (n2 == 0) {
            return;
        }
        if (this.auralAttribsChanged && (n = this.findActiveSoundscapes()) > 0) {
            this.aaRetained = (AuralAttributesRetained)this.findClosestAAttribs(n).clone();
        }
        if (n2 > 0) {
            this.calcSchedulingAction();
            this.muteSilentSounds();
            this.positionalSoundUpdated = false;
            if (this.testListenerFlag()) {
                this.audioDevice3D.setView(this.view);
            }
            n3 = this.performActions();
            if (this.positionalSoundUpdated) {
                this.clearListenerFlag();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int prioritizeSounds() {
        int n;
        ArrayList arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            if (!this.prioritizedSounds.isEmpty()) {
                this.prioritizedSounds.clear();
            }
            UnorderList unorderList = this.universe.soundStructure.getSoundList(this.view);
            this.nRetainedSounds = 0;
            this.nImmedSounds = 0;
            int n2 = 0;
            while (n2 < unorderList.size()) {
                this.addPrioritizedSound((SoundRetained)unorderList.get(n2));
                ++this.nRetainedSounds;
                ++n2;
            }
            Enumeration enumeration = this.view.getAllCanvas3Ds();
            while (enumeration.hasMoreElements()) {
                Canvas3D canvas3D = (Canvas3D)enumeration.nextElement();
                GraphicsContext3D graphicsContext3D = canvas3D.getGraphicsContext3D();
                Enumeration enumeration2 = graphicsContext3D.getAllSounds();
                while (enumeration2.hasMoreElements()) {
                    Sound sound = (Sound)enumeration2.nextElement();
                    if (sound == null) continue;
                    this.addPrioritizedSound((SoundRetained)sound.retained);
                    ++this.nImmedSounds;
                }
            }
            this.debugPrint(" prioritizeSound , num of processed non-retained sounds" + this.nImmedSounds);
            n = this.prioritizedSounds.size();
        }
        return n;
    }

    void addPrioritizedSound(SoundRetained soundRetained) {
        SoundRetained soundRetained2 = soundRetained.sgSound;
        if (soundRetained2 == null) {
            soundRetained.sgSound = soundRetained;
            soundRetained2 = soundRetained;
        }
        boolean bl = false;
        SoundSchedulerAtom soundSchedulerAtom = null;
        soundSchedulerAtom = this.findSoundAtom(soundRetained, 1);
        if (soundSchedulerAtom == null) {
            soundSchedulerAtom = new SoundSchedulerAtom();
            soundSchedulerAtom.soundScheduler = this;
            bl = true;
        }
        soundSchedulerAtom.sound = soundRetained;
        this.updateTransformedFields(soundRetained);
        if (!bl) {
            return;
        }
        soundSchedulerAtom.enable(soundRetained2.enable);
        if (this.prioritizedSounds.isEmpty()) {
            this.prioritizedSounds.add(soundSchedulerAtom);
        } else {
            int n = this.prioritizedSounds.size() - 1;
            float f = soundRetained2.priority;
            int n2 = n;
            while (n2 >= 0) {
                SoundSchedulerAtom soundSchedulerAtom2 = (SoundSchedulerAtom)this.prioritizedSounds.get(n2);
                SoundRetained soundRetained3 = soundSchedulerAtom2.sound;
                if (f <= soundRetained3.sgSound.priority) {
                    if (n2 == n) {
                        this.prioritizedSounds.add(soundSchedulerAtom);
                        break;
                    }
                    this.prioritizedSounds.add(n2 + 1, soundSchedulerAtom);
                    break;
                }
                --n2;
            }
            if (n2 < 0) {
                this.prioritizedSounds.add(0, soundSchedulerAtom);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int findActiveSoundscapes() {
        int n = 0;
        int n2 = 0;
        Object var3_3 = null;
        SoundscapeRetained soundscapeRetained = null;
        boolean bl = false;
        int n3 = 0;
        UnorderList unorderList = null;
        if (this.universe == null) {
            return 0;
        }
        unorderList = this.universe.soundStructure.getSoundscapeList(this.view);
        if (unorderList == null) {
            return 0;
        }
        UnorderList unorderList2 = unorderList;
        synchronized (unorderList2) {
            block13: {
                n3 = unorderList.size;
                if (n3 != 0) break block13;
                int n4 = 0;
                return n4;
            }
            if (this.intersectedRegions.length < n) {
                this.intersectedRegions = new Bounds[n + 32];
            }
            if (this.intersectedSoundscapes.length < n) {
                this.intersectedSoundscapes = new SoundscapeRetained[n + 32];
            }
            n2 = 0;
            int n5 = 0;
            while (n5 < n3) {
                soundscapeRetained = (SoundscapeRetained)unorderList.get(n5);
                if (soundscapeRetained.transformedRegion != null) {
                    if (this.region instanceof BoundingSphere && soundscapeRetained.transformedRegion instanceof BoundingSphere || this.region instanceof BoundingBox && soundscapeRetained.transformedRegion instanceof BoundingBox || this.region instanceof BoundingPolytope && soundscapeRetained.transformedRegion instanceof BoundingPolytope) {
                        soundscapeRetained.transformedRegion.getWithLock(this.region);
                    } else {
                        this.region = (Bounds)soundscapeRetained.transformedRegion.clone();
                    }
                    if (this.region != null && this.viewPlatform.schedSphere.intersect(this.region)) {
                        this.intersectedRegions[n2] = (Bounds)this.region.clone();
                        this.intersectedSoundscapes[n2] = soundscapeRetained;
                        ++n2;
                    }
                }
                ++n5;
            }
        }
        return n2;
    }

    AuralAttributesRetained findClosestAAttribs(int n) {
        AuralAttributes auralAttributes = null;
        SoundscapeRetained soundscapeRetained = null;
        boolean bl = false;
        soundscapeRetained = null;
        if (n == 1) {
            soundscapeRetained = this.intersectedSoundscapes[0];
        } else if (n > 1) {
            Bounds bounds = this.viewPlatform.schedSphere.closestIntersection(this.intersectedRegions);
            int n2 = 0;
            while (n2 < this.intersectedRegions.length) {
                if (this.intersectedRegions[n2] == bounds) {
                    soundscapeRetained = this.intersectedSoundscapes[n2];
                    break;
                }
                ++n2;
            }
        }
        if (soundscapeRetained == null || (auralAttributes = soundscapeRetained.getAuralAttributes()) != null) {
            // empty if block
        }
        return (AuralAttributesRetained)auralAttributes.retained;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateAuralAttribs(AuralAttributesRetained auralAttributesRetained) {
        if (this.auralAttribsChanged) {
            if (auralAttributesRetained != null) {
                AuralAttributesRetained auralAttributesRetained2 = auralAttributesRetained;
                synchronized (auralAttributesRetained2) {
                    Object object;
                    Object object2;
                    this.audioDevice3D.setRolloff(auralAttributesRetained.rolloff);
                    int n = auralAttributesRetained.getDistanceFilterLength();
                    if (auralAttributesRetained.filterType == -1 || n == 0) {
                        this.audioDevice3D.setDistanceFilter(-1, null, null);
                    } else {
                        object2 = new Point2f[n];
                        int n2 = 0;
                        while (n2 < n) {
                            object2[n2] = new Point2f();
                            ++n2;
                        }
                        auralAttributesRetained.getDistanceFilter((Point2f[])object2);
                        object = new double[n];
                        float[] fArray = new float[n];
                        int n3 = 0;
                        while (n3 < n) {
                            object[n3] = object2[n3].x;
                            fArray[n3] = object2[n3].y;
                            ++n3;
                        }
                        this.audioDevice3D.setDistanceFilter(auralAttributesRetained.filterType, (double[])object, fArray);
                    }
                    this.audioDevice3D.setFrequencyScaleFactor(auralAttributesRetained.frequencyScaleFactor);
                    this.audioDevice3D.setVelocityScaleFactor(auralAttributesRetained.velocityScaleFactor);
                    this.audioDevice3D.setReflectionCoefficient(auralAttributesRetained.reflectionCoefficient);
                    if (this.audioDevice3DL2 != null) {
                        this.audioDevice3DL2.setReverbCoefficient(auralAttributesRetained.reverbCoefficient);
                        this.audioDevice3DL2.setDecayFilter(auralAttributesRetained.decayFilter);
                        this.audioDevice3DL2.setDiffusion(auralAttributesRetained.diffusion);
                        this.audioDevice3DL2.setDensity(auralAttributesRetained.density);
                    }
                    if ((object2 = auralAttributesRetained.reverbBounds) == null) {
                        this.audioDevice3D.setReverbDelay(auralAttributesRetained.reverbDelay);
                    } else {
                        float f;
                        if (object2 instanceof BoundingSphere) {
                            f = (float)(2.0 * ((BoundingSphere)object2).radius / (double)0.344f);
                        } else {
                            object = new BoundingSphere((Bounds)object2);
                            f = (float)(2.0 * object.radius / (double)0.344f);
                        }
                        this.audioDevice3D.setReverbDelay(f);
                    }
                    this.audioDevice3D.setReverbOrder(auralAttributesRetained.reverbOrder);
                    if (this.audioDevice3DL2 != null) {
                        this.audioDevice3DL2.setDecayTime(auralAttributesRetained.decayTime);
                    }
                }
                this.resetAA = true;
            } else if (this.lastAA != null) {
                this.audioDevice3D.setRolloff(1.0f);
                this.audioDevice3D.setReflectionCoefficient(0.0f);
                this.audioDevice3D.setReverbDelay(40.0f);
                this.audioDevice3D.setReverbOrder(0);
                this.audioDevice3D.setDistanceFilter(-1, null, null);
                this.audioDevice3D.setFrequencyScaleFactor(1.0f);
                this.audioDevice3D.setVelocityScaleFactor(0.0f);
                if (this.audioDevice3DL2 != null) {
                    this.audioDevice3DL2.setReverbCoefficient(0.0f);
                    this.audioDevice3DL2.setReflectionDelay(20.0f);
                    this.audioDevice3DL2.setDecayTime(1000.0f);
                    this.audioDevice3DL2.setDecayFilter(5000.0f);
                    this.audioDevice3DL2.setDiffusion(1.0f);
                    this.audioDevice3DL2.setDensity(1.0f);
                }
                this.resetAA = true;
            }
            this.lastAA = auralAttributesRetained;
            this.auralAttribsChanged = false;
        }
    }

    void processSoundAtom(SoundSchedulerAtom soundSchedulerAtom) {
        SoundRetained soundRetained = soundSchedulerAtom.sound;
        SoundRetained soundRetained2 = soundRetained.sgSound;
        if (soundSchedulerAtom.status == 4 && soundSchedulerAtom.enabled != 2) {
            return;
        }
        if (soundSchedulerAtom.loadStatus != 2) {
            this.attachSoundData(soundSchedulerAtom, soundRetained2.soundData, false);
        }
        if (soundSchedulerAtom.loadStatus != 2) {
            return;
        }
        if (this.resetAA) {
            soundSchedulerAtom.setAttribsDirtyFlag(2);
        }
        boolean bl = false;
        if (!this.updateThread.active) {
            this.region = null;
            bl = false;
        } else if (soundRetained2.getInImmCtx()) {
            this.region = null;
            bl = true;
        } else {
            if (soundRetained2.schedulingRegion != null && soundRetained.transformedRegion != null) {
                if (this.region instanceof BoundingSphere && soundRetained.transformedRegion instanceof BoundingSphere || this.region instanceof BoundingBox && soundRetained.transformedRegion instanceof BoundingBox || this.region instanceof BoundingPolytope && soundRetained.transformedRegion instanceof BoundingPolytope) {
                    soundRetained.transformedRegion.getWithLock(this.region);
                } else {
                    this.region = (Bounds)soundRetained.transformedRegion.clone();
                }
            } else {
                this.region = null;
            }
            bl = this.region != null ? this.viewPlatform.schedSphere.intersect(this.region) : false;
        }
        soundSchedulerAtom.schedulingAction = (soundRetained2.getInImmCtx() || bl && soundRetained.switchState != null && soundRetained.switchState.currentSwitchOn) && (soundSchedulerAtom.muted == 0 || soundSchedulerAtom.muted == 2) ? soundSchedulerAtom.calcActiveSchedAction() : soundSchedulerAtom.calcInactiveSchedAction();
        if (soundSchedulerAtom.schedulingAction == 3 && (soundSchedulerAtom.testDirtyFlags() || this.testListenerFlag() && !(soundRetained2 instanceof BackgroundSoundRetained))) {
            soundSchedulerAtom.schedulingAction = 18;
        }
        switch (soundSchedulerAtom.schedulingAction) {
            case 17: {
                soundSchedulerAtom.status = 0;
                this.turnOff(soundSchedulerAtom);
                soundSchedulerAtom.schedulingAction = 1;
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                long l = System.currentTimeMillis();
                if (soundSchedulerAtom.endTime <= 0L || soundSchedulerAtom.endTime > l) break;
                soundSchedulerAtom.schedulingAction = 19;
                soundSchedulerAtom.status = 4;
                this.turnOff(soundSchedulerAtom);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            default: {
                soundSchedulerAtom.schedulingAction = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int calcSchedulingAction() {
        int n = 0;
        int n2 = 0;
        if (this.universe == null) {
            return 0;
        }
        if (this.universe.soundStructure == null) {
            return 0;
        }
        ArrayList arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            n = this.prioritizedSounds.size();
            int n3 = 0;
            while (n3 < n) {
                SoundSchedulerAtom soundSchedulerAtom = (SoundSchedulerAtom)this.prioritizedSounds.get(n3);
                SoundRetained soundRetained = soundSchedulerAtom.sound;
                SoundRetained soundRetained2 = soundRetained.sgSound;
                boolean bl = false;
                if (!soundRetained2.source.isLive() && !soundRetained2.getInImmCtx()) {
                    if (soundSchedulerAtom.playing || soundSchedulerAtom.enabled == 1) {
                        soundSchedulerAtom.setEnableState(3);
                        bl = true;
                    } else if (soundSchedulerAtom.enabled == 3) {
                        bl = true;
                    } else if (soundSchedulerAtom.enabled == 2) {
                        soundSchedulerAtom.setEnableState(0);
                    }
                } else {
                    bl = true;
                }
                if (bl) {
                    ++n2;
                    this.processSoundAtom(soundSchedulerAtom);
                } else {
                    soundSchedulerAtom.schedulingAction = 0;
                }
                ++n3;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void muteSilentSounds() {
        int n = 0;
        ArrayList arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            int n2 = this.prioritizedSounds.size();
            int n3 = 0;
            while (n3 < n2) {
                SoundSchedulerAtom soundSchedulerAtom = (SoundSchedulerAtom)this.prioritizedSounds.get(n3);
                SoundRetained soundRetained = soundSchedulerAtom.sound;
                SoundRetained soundRetained2 = soundRetained.sgSound;
                int n4 = soundSchedulerAtom.sampleId;
                int n5 = soundSchedulerAtom.status;
                if (soundSchedulerAtom.status != 4 && soundSchedulerAtom.schedulingAction != 0 && n4 != -1) {
                    int n6;
                    if (soundSchedulerAtom.schedulingAction == 12 || soundSchedulerAtom.schedulingAction == 7 || soundSchedulerAtom.schedulingAction == 2 || soundSchedulerAtom.schedulingAction == 8) {
                        if (n5 != 2) {
                            this.audioDevice3D.muteSample(n4);
                        }
                        soundSchedulerAtom.numberChannels = n6 = this.audioDevice3D.getNumberOfChannelsUsed(n4);
                        n += n6;
                    } else {
                        n6 = this.audioDevice3D.getNumberOfChannelsUsed(n4, false);
                        if (n + n6 > this.totalChannels) {
                            if (soundSchedulerAtom.schedulingAction == 11 || soundSchedulerAtom.schedulingAction == 3) {
                                soundSchedulerAtom.schedulingAction = 12;
                            } else if (soundSchedulerAtom.schedulingAction == 5) {
                                soundSchedulerAtom.schedulingAction = 7;
                            } else if (soundSchedulerAtom.schedulingAction == 6) {
                                soundSchedulerAtom.schedulingAction = 8;
                            } else if (soundSchedulerAtom.schedulingAction == 13) {
                                soundSchedulerAtom.schedulingAction = 14;
                            } else if (soundSchedulerAtom.schedulingAction == 15) {
                                soundSchedulerAtom.schedulingAction = 16;
                            }
                            this.audioDevice3D.muteSample(n4);
                        } else if (n5 != 1) {
                            this.audioDevice3D.unmuteSample(n4);
                        }
                        soundSchedulerAtom.numberChannels = n6 = this.audioDevice3D.getNumberOfChannelsUsed(n4);
                        n += n6;
                    }
                }
                ++n3;
            }
        }
    }

    void muteSilentSound(SoundSchedulerAtom soundSchedulerAtom) {
        SoundRetained soundRetained = soundSchedulerAtom.sound;
        SoundRetained soundRetained2 = soundRetained.sgSound;
        int n = soundSchedulerAtom.sampleId;
        int n2 = soundSchedulerAtom.status;
        if (n2 == 4) {
            return;
        }
        if (n == -1) {
            return;
        }
        if ((soundSchedulerAtom.schedulingAction == 12 || soundSchedulerAtom.schedulingAction == 7 || soundSchedulerAtom.schedulingAction == 2 || soundSchedulerAtom.schedulingAction == 8) && n2 != 2) {
            this.audioDevice3D.muteSample(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long shortestTimeToFinish() {
        long l = System.currentTimeMillis();
        long l2 = -1L;
        ArrayList arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            int n = this.prioritizedSounds.size();
            int n2 = 0;
            while (n2 < n) {
                long l3;
                SoundSchedulerAtom soundSchedulerAtom = (SoundSchedulerAtom)this.prioritizedSounds.get(n2);
                if (soundSchedulerAtom.status != 0 && soundSchedulerAtom.status != 4 && (l3 = soundSchedulerAtom.endTime) >= 0L) {
                    long l4 = l3 - l;
                    if (l4 < 0L) {
                        l4 = 0L;
                    }
                    if (l2 < 0L) {
                        l2 = l4;
                    } else if (l4 < l2) {
                        l2 = l4;
                    }
                }
                ++n2;
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int performActions() {
        int n = 0;
        ArrayList arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            int n2 = this.prioritizedSounds.size();
            int n3 = 0;
            while (n3 < n2) {
                SoundSchedulerAtom soundSchedulerAtom = (SoundSchedulerAtom)this.prioritizedSounds.get(n3);
                SoundRetained soundRetained = soundSchedulerAtom.sound;
                SoundRetained soundRetained2 = soundRetained.sgSound;
                int n4 = soundSchedulerAtom.sampleId;
                if (n4 != -1) {
                    this.resetAA = false;
                    AuralAttributesRetained auralAttributesRetained = soundRetained2.getInImmCtx() ? (this.graphicsCtx != null && this.graphicsCtx.auralAttributes != null ? (this.aaImmed = (AuralAttributesRetained)this.graphicsCtx.auralAttributes.retained) : null) : this.aaRetained;
                    this.updateAuralAttribs(auralAttributesRetained);
                    switch (soundSchedulerAtom.schedulingAction) {
                        case 5: {
                            this.turnOff(soundSchedulerAtom);
                        }
                        case 6: {
                            if (soundSchedulerAtom.paused == 3) {
                                this.pause(soundSchedulerAtom);
                            }
                            if (soundSchedulerAtom.paused == 2) {
                                this.unpause(soundSchedulerAtom);
                            }
                            if (soundSchedulerAtom.paused == 0) {
                                soundSchedulerAtom.status = 1;
                                this.render(true, soundSchedulerAtom, auralAttributesRetained);
                            } else {
                                soundSchedulerAtom.status = 3;
                                soundSchedulerAtom.setEnableState(2);
                            }
                            ++n;
                            break;
                        }
                        case 7: {
                            this.turnOff(soundSchedulerAtom);
                        }
                        case 8: {
                            if (soundSchedulerAtom.paused == 3) {
                                this.pause(soundSchedulerAtom);
                            }
                            if (soundSchedulerAtom.paused == 2) {
                                this.unpause(soundSchedulerAtom);
                            }
                            if (soundSchedulerAtom.paused == 0) {
                                soundSchedulerAtom.status = 2;
                                this.render(true, soundSchedulerAtom, auralAttributesRetained);
                            } else {
                                soundSchedulerAtom.status = 3;
                                soundSchedulerAtom.setEnableState(2);
                            }
                            ++n;
                            break;
                        }
                        case 15: {
                            this.unpause(soundSchedulerAtom);
                        }
                        case 11: {
                            soundSchedulerAtom.status = 1;
                            this.render(false, soundSchedulerAtom, auralAttributesRetained);
                            ++n;
                            break;
                        }
                        case 16: {
                            this.unpause(soundSchedulerAtom);
                        }
                        case 12: {
                            this.render(false, soundSchedulerAtom, auralAttributesRetained);
                            soundSchedulerAtom.status = 2;
                            ++n;
                            break;
                        }
                        case 13: 
                        case 14: {
                            this.pause(soundSchedulerAtom);
                            soundSchedulerAtom.status = 3;
                            ++n;
                            break;
                        }
                        case 18: {
                            this.render(false, soundSchedulerAtom, auralAttributesRetained);
                            ++n;
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: {
                            if (this.resetAA || soundSchedulerAtom.testDirtyFlags()) {
                                this.render(false, soundSchedulerAtom, auralAttributesRetained);
                            }
                            ++n;
                            break;
                        }
                        case 17: {
                            this.turnOff(soundSchedulerAtom);
                            break;
                        }
                        case 0: 
                        case 1: 
                        case 19: {
                            break;
                        }
                    }
                    soundSchedulerAtom.clearStateDirtyFlag();
                    soundSchedulerAtom.clearAttribsDirtyFlag();
                }
                ++n3;
            }
        }
        this.resetAA = false;
        return n;
    }

    void render(boolean bl, SoundSchedulerAtom soundSchedulerAtom, AuralAttributesRetained auralAttributesRetained) {
        SoundRetained soundRetained = soundSchedulerAtom.sound;
        SoundRetained soundRetained2 = soundRetained.sgSound;
        if (soundSchedulerAtom.sampleId == -1 || soundSchedulerAtom.soundData == null) {
            return;
        }
        int n = soundSchedulerAtom.sampleId;
        if (bl) {
            if (soundRetained2 instanceof PointSoundRetained || soundRetained2 instanceof ConeSoundRetained) {
                this.updateXformedParams(true, soundSchedulerAtom);
            }
            this.updateSoundParams(true, soundSchedulerAtom, auralAttributesRetained);
            this.start(soundSchedulerAtom);
        } else if (soundSchedulerAtom.status == 1) {
            if (soundRetained2 instanceof PointSoundRetained || soundRetained2 instanceof ConeSoundRetained) {
                this.updateXformedParams(false, soundSchedulerAtom);
            }
            this.updateSoundParams(false, soundSchedulerAtom, auralAttributesRetained);
            this.update(soundSchedulerAtom);
        }
    }

    void start(SoundSchedulerAtom soundSchedulerAtom) {
        SoundRetained soundRetained = soundSchedulerAtom.sound.sgSound;
        int n = soundSchedulerAtom.sampleId;
        int n2 = -1;
        if (n != -1 && (n2 = this.audioDevice3D.startSample(n)) >= 0) {
            soundSchedulerAtom.playing = true;
            soundSchedulerAtom.startTime = this.audioDevice3D.getStartTime(n);
            soundSchedulerAtom.calculateEndTime();
        } else {
            soundSchedulerAtom.startTime = 0L;
            soundSchedulerAtom.endTime = 0L;
            soundSchedulerAtom.playing = false;
        }
    }

    void update(SoundSchedulerAtom soundSchedulerAtom) {
        int n = soundSchedulerAtom.sampleId;
        if (n == -1) {
            return;
        }
        SoundRetained soundRetained = soundSchedulerAtom.sound;
        this.audioDevice3D.updateSample(n);
        soundSchedulerAtom.calculateEndTime();
        if (soundRetained instanceof PointSoundRetained || soundRetained instanceof ConeSoundRetained) {
            this.positionalSoundUpdated = true;
        }
    }

    void stopSound(SoundSchedulerAtom soundSchedulerAtom, boolean bl) {
        if (this.audioDevice3D == null) {
            return;
        }
        switch (soundSchedulerAtom.enabled) {
            case 1: {
                if (bl) {
                    soundSchedulerAtom.setEnableState(2);
                    break;
                }
                soundSchedulerAtom.setEnableState(0);
                break;
            }
            case 3: {
                soundSchedulerAtom.setEnableState(0);
                break;
            }
            case 2: {
                if (bl) break;
                soundSchedulerAtom.setEnableState(0);
                break;
            }
        }
        soundSchedulerAtom.status = 0;
        this.turnOff(soundSchedulerAtom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void deactivateAllSounds() {
        if (this.audioDevice3D == null) {
            return;
        }
        ArrayList arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            if (this.prioritizedSounds != null) {
                int n = this.prioritizedSounds.size();
                int n2 = 0;
                while (n2 < n) {
                    SoundSchedulerAtom soundSchedulerAtom = (SoundSchedulerAtom)this.prioritizedSounds.get(n2);
                    SoundRetained soundRetained = soundSchedulerAtom.sound;
                    SoundRetained soundRetained2 = soundRetained.sgSound;
                    if (soundRetained2.continuous) {
                        soundSchedulerAtom.schedulingAction = soundSchedulerAtom.calcInactiveSchedAction();
                        this.muteSilentSound(soundSchedulerAtom);
                    } else {
                        this.stopSound(soundSchedulerAtom, true);
                        soundSchedulerAtom.schedulingAction = 1;
                    }
                    ++n2;
                }
            }
        }
        this.performActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void pauseAllSounds() {
        if (this.audioDevice3D == null) {
            return;
        }
        this.stallThread = true;
        ArrayList arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            if (this.prioritizedSounds != null) {
                int n = this.prioritizedSounds.size();
                int n2 = 0;
                while (n2 < n) {
                    SoundSchedulerAtom soundSchedulerAtom = (SoundSchedulerAtom)this.prioritizedSounds.get(n2);
                    SoundRetained soundRetained = soundSchedulerAtom.sound;
                    SoundRetained soundRetained2 = soundRetained.sgSound;
                    switch (soundSchedulerAtom.enabled) {
                        case 1: 
                        case 3: {
                            this.pause(soundSchedulerAtom);
                            break;
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void resumeAllSounds() {
        if (this.audioDevice3D == null) {
            return;
        }
        ArrayList arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            if (this.prioritizedSounds != null) {
                int n = this.prioritizedSounds.size();
                int n2 = 0;
                while (n2 < n) {
                    SoundSchedulerAtom soundSchedulerAtom = (SoundSchedulerAtom)this.prioritizedSounds.get(n2);
                    SoundRetained soundRetained = soundSchedulerAtom.sound;
                    SoundRetained soundRetained2 = soundRetained.sgSound;
                    switch (soundSchedulerAtom.enabled) {
                        case 1: 
                        case 3: {
                            this.unpause(soundSchedulerAtom);
                            break;
                        }
                    }
                    ++n2;
                }
            }
        }
        this.stallThread = false;
    }

    synchronized void stopAllSounds() {
        this.stopAllSounds(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void stopAllSounds(boolean bl) {
        if (this.audioDevice3D == null) {
            return;
        }
        if (this.lastEventReceived == 203) {
            return;
        }
        ArrayList arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            if (this.prioritizedSounds != null) {
                int n = this.prioritizedSounds.size();
                int n2 = 0;
                while (n2 < n) {
                    SoundSchedulerAtom soundSchedulerAtom = (SoundSchedulerAtom)this.prioritizedSounds.get(n2);
                    this.stopSound(soundSchedulerAtom, bl);
                    ++n2;
                }
            }
        }
    }

    void pause(SoundSchedulerAtom soundSchedulerAtom) {
        if (soundSchedulerAtom.sampleId == -1) {
            return;
        }
        this.audioDevice3D.pauseSample(soundSchedulerAtom.sampleId);
        soundSchedulerAtom.setPauseState(1);
    }

    void unpause(SoundSchedulerAtom soundSchedulerAtom) {
        if (soundSchedulerAtom.sampleId == -1) {
            return;
        }
        this.audioDevice3D.unpauseSample(soundSchedulerAtom.sampleId);
        soundSchedulerAtom.setPauseState(0);
    }

    void turnOff(SoundSchedulerAtom soundSchedulerAtom) {
        if (soundSchedulerAtom.sampleId == -1) {
            return;
        }
        if (this.audioDevice3D.stopSample(soundSchedulerAtom.sampleId) < 0) {
            // empty if block
        }
        soundSchedulerAtom.playing = false;
        soundSchedulerAtom.startTime = 0L;
        soundSchedulerAtom.endTime = 0L;
    }

    void updateXformedParams(boolean bl, SoundSchedulerAtom soundSchedulerAtom) {
        Object object;
        Object object2;
        PointSoundRetained pointSoundRetained = (PointSoundRetained)soundSchedulerAtom.sound;
        PointSoundRetained pointSoundRetained2 = (PointSoundRetained)pointSoundRetained.sgSound;
        int n = soundSchedulerAtom.sampleId;
        if (n == -1) {
            return;
        }
        PointSoundRetained pointSoundRetained3 = pointSoundRetained;
        if (bl || this.testListenerFlag() || soundSchedulerAtom.testDirtyFlag(soundSchedulerAtom.attribsDirty, 64) || soundSchedulerAtom.testDirtyFlag(soundSchedulerAtom.stateDirty, 32768)) {
            object2 = new Point3f();
            pointSoundRetained.getXformPosition((Point3f)object2);
            object = new Point3d((Point3f)object2);
            this.audioDevice3D.setPosition(n, (Point3d)object);
        }
        if (pointSoundRetained instanceof ConeSoundRetained) {
            object2 = (ConeSoundRetained)pointSoundRetained;
            object = (ConeSoundRetained)pointSoundRetained.sgSound;
            if (bl || soundSchedulerAtom.testDirtyFlag(soundSchedulerAtom.attribsDirty, 33280)) {
                Vector3f vector3f = new Vector3f();
                ((ConeSoundRetained)object2).getXformDirection(vector3f);
                Vector3d vector3d = new Vector3d(vector3f);
                this.audioDevice3D.setDirection(n, vector3d);
            }
        }
    }

    void updateSoundParams(boolean bl, SoundSchedulerAtom soundSchedulerAtom, AuralAttributesRetained auralAttributesRetained) {
        float[] fArray;
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3;
        int n;
        PointSoundRetained pointSoundRetained;
        SoundRetained soundRetained = soundSchedulerAtom.sound;
        SoundRetained soundRetained2 = soundRetained.sgSound;
        int n2 = soundSchedulerAtom.sampleId;
        if (n2 == -1) {
            return;
        }
        if (bl || soundSchedulerAtom.testDirtyFlag(soundSchedulerAtom.attribsDirty, 2)) {
            if (auralAttributesRetained != null) {
                this.audioDevice3D.setSampleGain(n2, soundRetained2.initialGain * auralAttributesRetained.attributeGain);
            } else {
                this.audioDevice3D.setSampleGain(n2, soundRetained2.initialGain);
            }
        }
        if (bl || soundSchedulerAtom.testDirtyFlag(soundSchedulerAtom.attribsDirty, 4)) {
            this.audioDevice3D.setLoop(n2, soundRetained2.loopCount);
        }
        if ((bl || soundSchedulerAtom.testDirtyFlag(soundSchedulerAtom.attribsDirty, 2048)) && this.audioDevice3DL2 != null) {
            this.audioDevice3DL2.setRateScaleFactor(n2, soundRetained2.rate);
        }
        if (bl || soundSchedulerAtom.testDirtyFlag(soundSchedulerAtom.attribsDirty, 128)) {
            if (soundRetained2 instanceof ConeSoundRetained) {
                pointSoundRetained = (ConeSoundRetained)soundRetained2;
                n = pointSoundRetained.getDistanceGainLength();
                if (n == 0) {
                    this.audioDevice3D.setDistanceGain(n2, null, null, null, null);
                } else {
                    objectArray3 = new Point2f[n];
                    objectArray2 = new Point2f[n];
                    int n3 = 0;
                    while (n3 < n) {
                        objectArray3[n3] = new Point2f();
                        objectArray2[n3] = new Point2f();
                        ++n3;
                    }
                    ((ConeSoundRetained)pointSoundRetained).getDistanceGain((Point2f[])objectArray3, (Point2f[])objectArray2);
                    objectArray = new double[n];
                    fArray = new float[n];
                    double[] dArray = new double[n];
                    float[] fArray2 = new float[n];
                    int n4 = 0;
                    while (n4 < n) {
                        objectArray[n4] = objectArray3[n4].x;
                        fArray[n4] = objectArray3[n4].y;
                        dArray[n4] = objectArray2[n4].x;
                        fArray2[n4] = objectArray2[n4].y;
                        ++n4;
                    }
                    this.audioDevice3D.setDistanceGain(n2, (double[])objectArray, fArray, dArray, fArray2);
                }
            } else if (soundRetained2 instanceof PointSoundRetained) {
                pointSoundRetained = (PointSoundRetained)soundRetained2;
                n = pointSoundRetained.getDistanceGainLength();
                if (n == 0) {
                    this.audioDevice3D.setDistanceGain(n2, null, null, null, null);
                } else {
                    objectArray3 = new Point2f[n];
                    int n5 = 0;
                    while (n5 < n) {
                        objectArray3[n5] = new Point2f();
                        ++n5;
                    }
                    pointSoundRetained.getDistanceGain((Point2f[])objectArray3);
                    double[] dArray = new double[n];
                    objectArray = new float[n];
                    int n6 = 0;
                    while (n6 < n) {
                        dArray[n6] = objectArray3[n6].x;
                        objectArray[n6] = objectArray3[n6].y;
                        ++n6;
                    }
                    this.audioDevice3D.setDistanceGain(n2, dArray, (float[])objectArray, null, null);
                }
            }
        }
        if (soundRetained2 instanceof ConeSoundRetained && (bl || soundSchedulerAtom.testDirtyFlag(soundSchedulerAtom.attribsDirty, 1024))) {
            pointSoundRetained = (ConeSoundRetained)soundRetained2;
            n = ((ConeSoundRetained)pointSoundRetained).getAngularAttenuationLength();
            if (n == 0) {
                objectArray3 = new double[2];
                objectArray2 = new float[2];
                objectArray3[0] = (Point2f)0.0;
                objectArray3[1] = (Point2f)1.5707963267948966;
                objectArray2[0] = (Point2f)1.0f;
                objectArray2[1] = (Point2f)0.0f;
                this.audioDevice3D.setAngularAttenuation(n2, -1, (double[])objectArray3, (float[])objectArray2, null);
            } else {
                objectArray3 = new Point3f[n];
                int n7 = 0;
                while (n7 < n) {
                    objectArray3[n7] = new Point3f();
                    ++n7;
                }
                ((ConeSoundRetained)pointSoundRetained).getAngularAttenuation((Point3f[])objectArray3);
                double[] dArray = new double[n];
                objectArray = new float[n];
                fArray = new float[n];
                int n8 = 0;
                while (n8 < n) {
                    dArray[n8] = objectArray3[n8].x;
                    objectArray[n8] = objectArray3[n8].y;
                    fArray[n8] = objectArray3[n8].z;
                    ++n8;
                }
                this.audioDevice3D.setAngularAttenuation(n2, ((ConeSoundRetained)pointSoundRetained).filterType, dArray, (float[])objectArray, fArray);
            }
        }
    }

    boolean checkAudioDevice3D() {
        if (this.universe != null && this.universe.currentView != null && this.universe.currentView.physicalEnvironment != null) {
            this.audioDevice = this.universe.currentView.physicalEnvironment.audioDevice;
            if (this.audioDevice != null) {
                if (this.audioDevice instanceof AudioDevice3DL2) {
                    this.audioDevice3DL2 = (AudioDevice3DL2)this.audioDevice;
                }
                if (this.audioDevice instanceof AudioDevice3D) {
                    this.audioDevice3D = (AudioDevice3D)this.audioDevice;
                }
            } else {
                this.audioDevice3DL2 = null;
                this.audioDevice3D = null;
            }
        }
        if (this.audioDevice3D == null) {
            return false;
        }
        return this.audioDevice3D.getTotalChannels() != 0;
    }

    void clearSoundData(SoundSchedulerAtom soundSchedulerAtom) {
        if (this.checkAudioDevice3D() && soundSchedulerAtom.sampleId != -1) {
            this.stopSound(soundSchedulerAtom, false);
            this.audioDevice3D.clearSound(soundSchedulerAtom.sampleId);
        }
        soundSchedulerAtom.sampleId = -1;
        soundSchedulerAtom.loadStatus = 0;
        SoundRetained soundRetained = soundSchedulerAtom.sound;
        soundSchedulerAtom.loadStatus = 0;
        soundSchedulerAtom.soundData = null;
        soundRetained.changeAtomList(soundSchedulerAtom, 0);
    }

    void attachSoundData(SoundSchedulerAtom soundSchedulerAtom, MediaContainer mediaContainer, boolean bl) {
        if (!bl && soundSchedulerAtom.soundData == mediaContainer) {
            return;
        }
        SoundRetained soundRetained = soundSchedulerAtom.sound.sgSound;
        if (!this.checkAudioDevice3D()) {
            soundSchedulerAtom.loadStatus = 1;
            soundRetained.changeAtomList(soundSchedulerAtom, 1);
            return;
        }
        if (soundSchedulerAtom.soundData != null) {
            this.clearSoundData(soundSchedulerAtom);
            if (mediaContainer == null) {
                return;
            }
        }
        URL uRL = ((MediaContainerRetained)soundRetained.soundData.retained).url;
        String string = ((MediaContainerRetained)soundRetained.soundData.retained).urlString;
        InputStream inputStream = ((MediaContainerRetained)soundRetained.soundData.retained).inputStream;
        if (uRL == null && string == null && inputStream == null) {
            if (soundSchedulerAtom.sampleId != -1) {
                this.clearSoundData(soundSchedulerAtom);
            }
            return;
        }
        soundRetained.soundType = soundRetained instanceof ConeSoundRetained ? 3 : (soundRetained instanceof PointSoundRetained ? 2 : 1);
        MediaContainer mediaContainer2 = new MediaContainer();
        mediaContainer2.duplicateAttributes(mediaContainer, true);
        mediaContainer2.setCapability(0);
        mediaContainer2.setCapability(2);
        int n = this.audioDevice3D.prepareSound(soundRetained.soundType, mediaContainer2);
        if (n == -1) {
            soundSchedulerAtom.loadStatus = -1;
            soundRetained.changeAtomList(soundSchedulerAtom, -1);
            System.err.println(string + ": " + J3dI18N.getString("SoundRetained1"));
        } else {
            long l;
            soundSchedulerAtom.sampleId = n;
            soundSchedulerAtom.loopLength = soundSchedulerAtom.sampleLength = (l = this.audioDevice3D.getSampleDuration(n));
            soundSchedulerAtom.loopStartOffset = 0L;
            soundSchedulerAtom.attackLength = 0L;
            soundSchedulerAtom.releaseLength = 0L;
            soundSchedulerAtom.loadStatus = 2;
            soundSchedulerAtom.soundData = mediaContainer;
            soundRetained.changeAtomList(soundSchedulerAtom, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SoundSchedulerAtom findSoundAtom(SoundRetained soundRetained, int n) {
        if (soundRetained == null) {
            return null;
        }
        SoundSchedulerAtom soundSchedulerAtom = null;
        ArrayList arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            if (!this.prioritizedSounds.isEmpty()) {
                SoundSchedulerAtom soundSchedulerAtom2 = null;
                int n2 = 0;
                int n3 = this.prioritizedSounds.size();
                int n4 = 0;
                while (n4 < n3) {
                    soundSchedulerAtom2 = (SoundSchedulerAtom)this.prioritizedSounds.get(n4);
                    if (soundSchedulerAtom2.sound != null) {
                        if (soundSchedulerAtom2.sound.sgSound == soundRetained) {
                            if (++n2 == n) {
                                soundSchedulerAtom = soundSchedulerAtom2;
                                break;
                            }
                        } else if (soundSchedulerAtom2.sound.sgSound == soundRetained.sgSound) {
                            soundSchedulerAtom2.sound = soundRetained;
                            if (++n2 == n) {
                                soundSchedulerAtom = soundSchedulerAtom2;
                                break;
                            }
                        }
                    }
                    ++n4;
                }
            }
        }
        return soundSchedulerAtom;
    }

    void setListenerFlag(int n) {
        this.listenerUpdated |= n;
    }

    void clearListenerFlag() {
        this.listenerUpdated = 0;
    }

    boolean testListenerFlag() {
        return this.listenerUpdated > 0;
    }

    void setAttribsDirtyFlag(SoundRetained soundRetained, int n) {
        SoundSchedulerAtom soundSchedulerAtom = null;
        int n2 = 1;
        while ((soundSchedulerAtom = this.findSoundAtom(soundRetained, n2)) != null) {
            soundSchedulerAtom.setAttribsDirtyFlag(n);
            ++n2;
        }
    }

    void setStateDirtyFlag(SoundRetained soundRetained, int n) {
        SoundSchedulerAtom soundSchedulerAtom = null;
        int n2 = 1;
        while ((soundSchedulerAtom = this.findSoundAtom(soundRetained, n2)) != null) {
            soundSchedulerAtom.setStateDirtyFlag(n);
            ++n2;
        }
    }

    void printAtomState(SoundSchedulerAtom soundSchedulerAtom) {
        SoundRetained soundRetained = soundSchedulerAtom.sound.sgSound;
        this.debugPrint("                  this atom = " + soundSchedulerAtom + "       ");
        this.debugPrint("                 references sound = " + soundRetained + "       ");
        this.debugPrint("                 enabled " + soundSchedulerAtom.enabled);
        this.debugPrint("                 status " + soundSchedulerAtom.status);
        this.debugPrint("                 activated " + soundSchedulerAtom.activated);
        this.debugPrint("                 released " + soundRetained.release);
        this.debugPrint("                 continuous " + soundRetained.continuous);
        this.debugPrint("                 scheduling " + soundSchedulerAtom.schedulingAction);
    }

    void debugPrint(String string) {
    }

    void processViewSpecificGroupChanged(J3dMessage j3dMessage) {
        Object e;
        int n;
        int n2;
        Object object;
        Object object2;
        int n3 = (Integer)j3dMessage.args[0];
        Object[] objectArray = (Object[])j3dMessage.args[1];
        if ((n3 & 2) != 0 || (n3 & 1) != 0) {
            object2 = (View)objectArray[0];
            object = (ArrayList)objectArray[2];
            if (object2 == this.view) {
                n2 = ((ArrayList)object).size();
                n = 0;
                while (n < n2) {
                    e = ((ArrayList)object).get(n);
                    if (e instanceof SoundRetained) {
                        ++this.nRetainedSounds;
                        this.addSound((SoundRetained)e);
                    } else if (e instanceof SoundscapeRetained) {
                        this.auralAttribsChanged = true;
                    }
                    ++n;
                }
            }
        }
        if ((n3 & 4) != 0 || (n3 & 1) != 0) {
            if ((n3 & 4) != 0) {
                object = (View)objectArray[0];
                object2 = (ArrayList)objectArray[2];
            } else {
                object = (View)objectArray[4];
                object2 = (ArrayList)objectArray[6];
            }
            if (object == this.view) {
                n2 = ((ArrayList)object2).size();
                n = 0;
                while (n < n2) {
                    e = ((ArrayList)object2).get(n);
                    if (e instanceof SoundRetained) {
                        SoundSchedulerAtom soundSchedulerAtom = null;
                        int n4 = 1;
                        while ((soundSchedulerAtom = this.findSoundAtom((SoundRetained)e, n4)) != null) {
                            this.stopSound(soundSchedulerAtom, false);
                            ++n4;
                        }
                    } else if (e instanceof SoundscapeRetained) {
                        this.auralAttribsChanged = true;
                    }
                    ++n;
                }
            }
        }
    }

    void processBoundingLeafChanged(J3dMessage j3dMessage) {
        Object[] objectArray = (Object[])j3dMessage.args[3];
        int n = 0;
        while (n < objectArray.length) {
            LeafRetained leafRetained = (LeafRetained)objectArray[n];
            if (leafRetained instanceof SoundRetained && this.universe.soundStructure.isSoundScopedToView(leafRetained, this.view)) {
                this.auralAttribsChanged = true;
            } else if (leafRetained instanceof SoundscapeRetained && this.universe.soundStructure.isSoundscapeScopedToView(leafRetained, this.view)) {
                this.auralAttribsChanged = true;
            }
            ++n;
        }
    }

    void cleanup() {
    }
}

