//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeimpl;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ISelection;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;

/**
 * <p>
 * this is the default implementation of the interface {@link ISelection}. It does not do anything
 * fancy except implementing the interface.
 * </p> 
 *
 * @author Patrick Harms
 */
class Selection extends StructuringTemporalRelationship implements ISelection {

    /**
     * <p>
     * default serial version UID
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * simple constructor providing the base class with a human readable name of the type of this
     * task
     * </p>
     */
    Selection() {
        super("selection");
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeimpl.StructuringTemporalRelationship#clone()
     */
    @Override
    public Selection clone() {
        return (Selection) super.clone();
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeimpl.StructuringTemporalRelationship#addChild(ITask)
     */
    @Override
    void addChild(ITask newChild) {
        super.addChild(newChild);
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeimpl.StructuringTemporalRelationship#addChild(int,ITask)
     */
    @Override
    void addChild(int index, ITask newChild) {
        super.addChild(index, newChild);
    }

}
