package de.ugoe.cs.autoquest.tasktrees.alignment.algorithms;

import java.util.LinkedList;
import java.util.Random;

public class NumberSequence {
	private int[] sequence;
	private int id;

	public NumberSequence(int size) {

		sequence = new int[size];
	}

	public int[] getSequence() {
		return sequence;
	}

	public void setSequence(int[] sequence) {
		this.sequence = sequence;
	}

	public void printSequence() {
		for (int i = 0; i < sequence.length; i++) {
			System.out.format("%5d", sequence[i]);
		}
		System.out.println();
	}

	public NumberSequence shuffle() {
		NumberSequence result = new NumberSequence(sequence.length);
		result.setId(getId());
		result.setSequence(this.sequence);
		Random rgen = new Random();

		for (int i = 0; i < result.sequence.length; i++) {
			int randomPosition = rgen.nextInt(result.sequence.length);
			int temp = result.sequence[i];
			result.sequence[i] = result.sequence[randomPosition];
			result.sequence[randomPosition] = temp;
		}
		return result;

	}

	//Recursive check if sequence contains pattern at position i
	private boolean matches(int i, int[] p1, int[] p2 ,int ip1,int ip2,boolean jumped1,boolean jumped2) {
		
		if(p1.length==ip1) {
			return true;
		}
		if(p2.length==ip2) {
			return true;
		}
		if(i==sequence.length) {
			return false;
		}
		if((p1[ip1]==sequence[i]||p2[ip2]==sequence[i]) && jumped1) {
			return matches(i+1,p1,p2,ip1+1,ip2+2,false,false);
		}
		if((p1[ip1]==sequence[i]||p2[ip2]==sequence[i]) && jumped2) {
			return matches(i+1,p1,p2,ip1+2,ip2+1,false,false);
		}
		if(p1[ip1]==sequence[i]||p2[ip2]==sequence[i]) {
			return matches(i+1,p1,p2,ip1+1,ip2+1,false,false);
		}
		if(p1[ip1]==-1) {
			return matches(i,p1,p2,ip1+1,ip2,true,false);
		}
		if(p2[ip2]==-1) {
			return matches(i,p1,p2,ip1,ip2+1,false,true);
		}
	
		return false;
	}
	
	//Searching occurrences of pattern
	public LinkedList<Integer> containsPattern(Match pattern) {
		LinkedList<Integer> result = new LinkedList<Integer>();
		int i = 0;
		int[] pat1 = pattern.getFirstSequence().getSequence();
		int[] pat2 = pattern.getSecondSequence().getSequence();

		while (i < sequence.length ) {
			if(matches(i,pat1,pat2,0,0,false,false)) {
				result.add(i);
			}
			i++;
		}
		return result;
	}

	// Returns the number of times event occurs in this sequence
	public int eventCount(int event) {
		int count = 0;
		for (int i = 0; i < sequence.length; i++) {
			if (sequence[i] == event) {
				count++;
			}
		}
		return count;
	}

	public int size() {
		return sequence.length;
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public boolean equals(NumberSequence n) {
		int[] seq = n.getSequence();
		if (n.size() != this.size()) {
			return false;
		}
		for (int i = 0; i < n.size(); i++) {
			if (seq[i] != this.sequence[i]) {
				return false;
			}
		}
		return true;
	}

}
