package de.ugoe.cs.autoquest.tasktrees.alignment.matrix;

import java.util.ArrayList;
import java.util.logging.Level;

import de.ugoe.cs.autoquest.tasktrees.alignment.algorithms.AlignmentAlgorithm;
import de.ugoe.cs.autoquest.tasktrees.alignment.algorithms.AlignmentAlgorithmFactory;
import de.ugoe.cs.autoquest.tasktrees.alignment.algorithms.NumberSequence;
import de.ugoe.cs.util.console.Console;

public class PairwiseAlignmentGenerator {

	public static PairwiseAlignmentStorage generate(
			ArrayList<NumberSequence> numberseqs,
			ObjectDistanceSubstitionMatrix submat, 
			int threshold) {
		PairwiseAlignmentStorage alignments = new PairwiseAlignmentStorage(
				numberseqs.size(), numberseqs.size());
		int smithWatermanThreshold = threshold;

		for (int i = 0; i < numberseqs.size(); i++) {
			NumberSequence ns1 = numberseqs.get(i);
			for (int j = 0; j < numberseqs.size(); j++) {
				NumberSequence ns2 = numberseqs.get(j);

				if (i != j) {
					Console.traceln(Level.FINEST,"Aligning sequence " + i + " with sequence " + j);
				
					AlignmentAlgorithm aa = AlignmentAlgorithmFactory.create();
					aa.align(ns1, ns2, submat,
							smithWatermanThreshold);
					alignments.set(i, j, aa);
				}
			}
		}
		return alignments;
	}
}
