package de.ugoe.cs.autoquest.tasktrees.alignment.matrix;


import java.util.HashMap;
import java.util.Iterator;

import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElement;
import de.ugoe.cs.autoquest.tasktrees.alignment.algorithms.AlignmentHelpers;
import de.ugoe.cs.autoquest.tasktrees.alignment.algorithms.Constants;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTaskInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstance;
import de.ugoe.cs.autoquest.usageprofiles.SymbolMap;


public class ObjectDistanceSubstitionMatrix implements SubstitutionMatrix {

	// private ArrayList<int[][]> matrix;
	HashMap<Integer, Integer> idmapping;
	private TriangleMatrix matrix;
	private SymbolMap<ITaskInstance, ITask> uniqueTasks;
	private double gapPenalty; 
	private int index = 0;
	
	private double positiveThreshold;
	
	public ObjectDistanceSubstitionMatrix(
			SymbolMap<ITaskInstance, ITask> uniqueTasks,float positiveThreshold, int gapPenalty) {
		this.uniqueTasks = uniqueTasks;
		this.positiveThreshold = positiveThreshold;
		idmapping = new HashMap<Integer, Integer>();
		matrix = new TriangleMatrix(uniqueTasks.size()+1);
		this.gapPenalty = gapPenalty;
		
	}


	public double getGapPenalty() {
		return gapPenalty;
	}
	
	public void setGapPenalty(double gapPenalty) {
		this.gapPenalty = gapPenalty;
	}

	public void generate() {
		
		for (Iterator<ITaskInstance> it = uniqueTasks.getSymbols().iterator(); it
				.hasNext();) {
			Object obj1 = it.next();
			IEventTaskInstance eti1 = null;
			if (obj1 instanceof IEventTaskInstance) {
				System.out.println(obj1);
				eti1 = (IEventTaskInstance) obj1;
			}
			else {
				//System.out.println("Not an EventTaskInstance");
				//System.out.println(obj1);
				continue;
			}
		
			for (Iterator<ITaskInstance> jt = uniqueTasks.getSymbols()
					.iterator(); jt.hasNext();) {
				IEventTaskInstance eti2 = null;
				Object obj2 = jt.next();
				if (obj2 instanceof IEventTaskInstance) {
					eti2 = (IEventTaskInstance) obj2;
				}
				else{
					//System.out.println("Not an EventtaskInstance");
					//System.out.println(obj1);
					continue;
				}
		
				matrix.set(getIndex(eti1), getIndex(eti2),distanceBetweenInstances(eti1,eti2));
	
			}
		}
	}
	
	private int getIndex(IEventTaskInstance eti) {
		int tempindex = -1;
		if(!idmapping.containsKey(eti.getTask().getId()))
		{
			idmapping.put(eti.getTask().getId(), index);
			tempindex = index;
			index++;
		}	
		else 
		{
			tempindex = idmapping.get(eti.getTask().getId());
		}
		return tempindex;
	}
	
	private float distanceBetweenInstances(IEventTaskInstance eti1, IEventTaskInstance eti2)  {
		IGUIElement first = (IGUIElement) eti1.getEvent().getTarget();
		IGUIElement second = (IGUIElement) eti2.getEvent().getTarget();
		float distance = -1*AlignmentHelpers.distanceBetween(first, second);
		distance += positiveThreshold;
		return distance;
	}
	
	public String toString(){
		return matrix.toString();
	}

	public double getScore(int taskId1, int taskId2) {
		if(taskId1 == Constants.GAP_SYMBOL || taskId1 == Constants.UNMATCHED_SYMBOL || taskId2 == Constants.GAP_SYMBOL || taskId2 == Constants.UNMATCHED_SYMBOL ) {
			return 0.0; 
		} 
		else {
			return matrix.get(idmapping.get(taskId1),idmapping.get(taskId2));	
		}
		
	}

}

