package de.ugoe.cs.autoquest.tasktrees.alignment.matrix;


import java.util.HashMap;
import java.util.Iterator;

import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElement;
import de.ugoe.cs.autoquest.tasktrees.alignment.algorithms.AlignmentHelpers;
import de.ugoe.cs.autoquest.tasktrees.alignment.algorithms.Constants;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTaskInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstance;
import de.ugoe.cs.autoquest.usageprofiles.SymbolMap;


public class ObjectDistanceSubstitionMatrix implements SubstitutionMatrix {

	// private ArrayList<int[][]> matrix;
	HashMap<Integer, Integer> idmapping;
	private TriangleMatrix matrix;
	private SymbolMap<ITaskInstance, ITask> uniqueTasks;
	private double gapPenalty; 
	private int index = 0;
	
	private double positiveThreshold;
	
	public ObjectDistanceSubstitionMatrix(
			SymbolMap<ITaskInstance, ITask> uniqueTasks,float positiveThreshold, int gapPenalty) {
		this.uniqueTasks = uniqueTasks;
		this.positiveThreshold = positiveThreshold;
		idmapping = new HashMap<Integer, Integer>();
		matrix = new TriangleMatrix(uniqueTasks.size()+1);
		this.gapPenalty = gapPenalty;
		
	}


	public double getGapPenalty() {
		return gapPenalty;
	}
	
	public void setGapPenalty(double gapPenalty) {
		this.gapPenalty = gapPenalty;
	}

	public void generate() {
		
		int index1=-1;
		int index2=-1;
		float distance=0;
		for (Iterator<ITaskInstance> it = uniqueTasks.getSymbols().iterator(); it
				.hasNext();) {
			Object obj1 = it.next();
			for (Iterator<ITaskInstance> jt = uniqueTasks.getSymbols()
					.iterator(); jt.hasNext();) {
			
				IEventTaskInstance eti1 = null;
				ITask task1 = null;
				
				IEventTaskInstance eti2 = null;
				ITask task2 = null;
				
				Object obj2 = jt.next();
				
				if (obj1 instanceof IEventTaskInstance && obj2 instanceof IEventTaskInstance) {
					eti1 = (IEventTaskInstance) obj1;
					index1 = getIndex(eti1);
					eti2 = (IEventTaskInstance) obj2;
					index2 = getIndex(eti2);
					distance = distanceBetweenInstances(eti1,eti2);
				}
				else if(obj1 instanceof IEventTaskInstance &&  !(obj2 instanceof IEventTaskInstance)) {
					task2 = ((ITaskInstance) obj2).getTask();
					index2 = getIndex(task2);
					eti1 = (IEventTaskInstance) obj1;
					index1 = getIndex(eti1);
					distance = distanceBetweenTaskAndInstance(task2,eti1);
				}
				else if(!(obj1 instanceof IEventTaskInstance) && obj2 instanceof IEventTaskInstance) {
					task1 = ((ITaskInstance) obj1).getTask();
					index1 = getIndex(task1);
					eti2 = (IEventTaskInstance) obj2;
					index2 = getIndex(eti2);
					distance = distanceBetweenTaskAndInstance(task1,eti2);
				}
				else if(!(obj2 instanceof IEventTaskInstance) && !(obj2 instanceof IEventTaskInstance)) {
					task1 = ((ITaskInstance) obj1).getTask();
					index1 = getIndex(task1);
					task2 = ((ITaskInstance) obj2).getTask();
					index2 = getIndex(task2);
					distance = distanceBetweenTasks(task1,task2);
				}
				else {
					System.out.println("Unknown error");
				}
				
				matrix.set(index1, index2,distance);
	
			}
		}
	}

	
	private float distanceBetweenTaskAndInstance(ITask task1, IEventTaskInstance eti) {
		return 0;
	}
	
	private float distanceBetweenTasks(ITask task1, ITask task2) {
		return 0;
	}


	private int getIndex(ITask task) {
		int tempindex =-1;
		if(!idmapping.containsKey(task.getId())) {
			idmapping.put(task.getId(), index);
			tempindex = index;
			index++;
		}
		else {
			tempindex = idmapping.get(task.getId());
		}
		return tempindex;
	}
	
	private int getIndex(IEventTaskInstance eti) {
		int tempindex = -1;
		if(!idmapping.containsKey(eti.getTask().getId())) {
			idmapping.put(eti.getTask().getId(), index);
			tempindex = index;
			index++;
		}	
		else {
			tempindex = idmapping.get(eti.getTask().getId());
		}
		return tempindex;
	};
	
	private float distanceBetweenInstances(IEventTaskInstance eti1, IEventTaskInstance eti2)  {
		IGUIElement first = (IGUIElement) eti1.getEvent().getTarget();
		IGUIElement second = (IGUIElement) eti2.getEvent().getTarget();
		float distance = -1*AlignmentHelpers.distanceBetween(first, second);
		distance += positiveThreshold;
		return distance;
	}
	
	public String toString(){
		return matrix.toString();
	}

	public double getScore(int taskId1, int taskId2) {
		if(taskId1 == Constants.GAP_SYMBOL || taskId1 == Constants.UNMATCHED_SYMBOL || taskId2 == Constants.GAP_SYMBOL || taskId2 == Constants.UNMATCHED_SYMBOL ) {
			return 0.0; 
		} 
		else {
			int first = idmapping.get(taskId1);
			int second = idmapping.get(taskId2);
			System.out.println("First: " + first + " Second: " + second);
			System.out.println("Matrix: " + matrix.get(first, second));
			return matrix.get(first,second);	
		}
		
	}

}

