//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.temporalrelation;

import org.junit.Test;

/**
 * @author Patrick Harms
 */
public class SequenceForTaskDetectionRuleAlignmentTest extends AbstractTemporalRelationshipTC {

    /**
     *
     */
    @Test
    public void test_TaskDetection_01() throws Exception {
        String input =
            "UserSession {" +
            "  Event noise0 {}" +
            "  Event action1 {}" +
            "  Event action2 {}" +
            "  Event action3 {}" +
            "  Event action4 {}" +
            "  Event noise1 {}" +
            "  Event noise2 {}" +
            "  Event action1 {}" +
            "  Event action2 {}" +
            "  Event action3 {}" +
            "  Event action4 {}" +
            "  Event noise3 {}" +
            "  Event noise4 {}" +
            "  Event noise5 {}" +
            "  Event noise6 {}" +
            "  Event action1 {}" +
            "  Event action2 {}" +
            "  Event action3 {}" +
            "  Event action4 {}" +
            "  Event action1 {}" +
            "  Event action2 {}" +
            "  Event action3 {}" +
            "  Event action4 {}" +
            "  Event noise7 {}" +
            "}";

        String output =
            "UserSession {" +
            "  Event noise0 {}" +
            "  Iteration iteration1 {" +
            "    Sequence sequence1 {" +
            "      Event action1 {}" +
            "      Event action2 {}" +
            "      Event action3 {}" +
            "      Event action4 {}" +
            "    }" +
            "  }" +
            "  Event noise1 {}" +
            "  Event noise2 {}" +
            "  Iteration iteration1 {" +
            "    Sequence sequence1 {" +
            "      Event action1 {}" +
            "      Event action2 {}" +
            "      Event action3 {}" +
            "      Event action4 {}" +
            "    }" +
            "  }" +
            "  Event noise3 {}" +
            "  Event noise4 {}" +
            "  Event noise5 {}" +
            "  Event noise6 {}" +
            "  Iteration iteration1 {" +
            "    Sequence sequence1 {" +
            "      Event action1 {}" +
            "      Event action2 {}" +
            "      Event action3 {}" +
            "      Event action4 {}" +
            "    }" +
            "    Sequence sequence1 {" +
            "      Event action1 {}" +
            "      Event action2 {}" +
            "      Event action3 {}" +
            "      Event action4 {}" +
            "    }" +
            "  }" +
            "  Event noise7 {}" +
            "}";

        applySessionScopeRule(SequenceForTaskDetectionRuleAlignment.class, input, output);
    }

    /**
     *
     */
    @Test
    public void test_TaskDetection_02() throws Exception {
        String input =
            "UserSession {" +
            "  Event noise0 {}" +
            "  Event action1 {}" +
            "  Event action2 {}" +
            "  Event noise1 {}" +
            "  Event noise2 {}" +
            "  Event action3 {}" +
            "  Event action1 {}" +
            "  Event action2 {}" +
            "  Event action4 {}" +
            "  Event noise3 {}" +
            "  Event noise4 {}" +
            "  Event noise5 {}" +
            "  Event noise6 {}" +
            "  Event action1 {}" +
            "  Event action2 {}" +
            "  Event action3 {}" +
            "  Event action4 {}" +
            "  Event action1 {}" +
            "  Event action2 {}" +
            "  Event action3 {}" +
            "  Event action4 {}" +
            "  Event noise7 {}" +
            "}";

        String output =
            "UserSession {" +
            "  Event noise0 {}" +
            "  Sequence sequence1 {" +
            "    Event action1 {}" +
            "    Event action2 {}" +
            "  }" +
            "  Event noise1 {}" +
            "  Event noise2 {}" +
            "  Event action3 {}" +
            "  Sequence sequence1 {" +
            "    Event action1 {}" +
            "    Event action2 {}" +
            "  }" +
            "  Event action4 {}" +
            "  Event noise3 {}" +
            "  Event noise4 {}" +
            "  Event noise5 {}" +
            "  Event noise6 {}" +
            "  Iteration iteration1 {" +
            "    Sequence sequence3 {" +
            "      Sequence sequence1 {" +
            "        Event action1 {}" +
            "        Event action2 {}" +
            "      }" +
            "      Event action3 {}" +
            "      Event action4 {}" +
            "    }" +
            "    Sequence sequence3 {" +
            "      Sequence sequence1 {" +
            "        Event action1 {}" +
            "        Event action2 {}" +
            "      }" +
            "      Event action3 {}" +
            "      Event action4 {}" +
            "    }" +
            "  }" +
            "  Event noise7 {}" +
            "}";

        applySessionScopeRule(SequenceForTaskDetectionRuleAlignment.class, input, output);
    }

}
