//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.alignment.commands;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;

import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.autoquest.plugin.alignment.SmithWaterman;
import de.ugoe.cs.autoquest.plugin.alignment.seqgen.SimpleSequenceGenerator;
import de.ugoe.cs.autoquest.plugin.alignment.substitution.NearbySubstitutionMatrix;
import de.ugoe.cs.autoquest.plugin.alignment.substitution.ObjectDistanceSubstitionMatrix;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;
import de.ugoe.cs.util.console.GlobalDataContainer;

/**
 * <p>
 * Command to generate a binary alignment of two sequences
 * </p>
 * 
 * @author Ralph Krimmel
 * @version 1.0
 */
public class CMDdeleteShortSequences implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@SuppressWarnings("unchecked")
	public void run(List<Object> parameters) {
		String sequencesName = "sequences";
		int delcount = 0;
		int limit = 10;
		try {
			sequencesName = (String) parameters.get(0);
			if (parameters.size() > 1) {
				try {
					limit = Integer.parseInt((String) parameters.get(1));
					}
				catch (NumberFormatException e)
				{
					Console.traceln(Level.WARNING,"Parameter not an integer. Using the default value.");
				}
			}
		} catch (Exception e) {
			throw new IllegalArgumentException();
		}

		Collection<List<Event>> sequences = new LinkedList<List<Event>>();
		Object obj = GlobalDataContainer.getInstance().getData(sequencesName);
		if (obj.getClass().equals(sequences.getClass())) {
			sequences = (Collection<List<Event>>) obj;
		}

		if (sequences != null) {
			Console.println("Number of sequences: " + sequences.size());
			Iterator<List<Event>> iter = sequences.iterator();
			while(iter.hasNext()) {
			    if (iter.next().size() < limit) {
			    	iter.remove();
			    	delcount++;
			    }
			}
			
			Console.traceln(Level.INFO, "Deleted "+ delcount + " short sequences from " + sequencesName);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public String help() {
		return "deleteShortSequences <sequence name>";
	}

}
