//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.alignment.commands;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.autoquest.plugin.alignment.SmithWaterman;
import de.ugoe.cs.autoquest.plugin.alignment.seqgen.SequenceGenerator;
import de.ugoe.cs.autoquest.plugin.alignment.seqgen.SimpleSequenceGenerator;
import de.ugoe.cs.autoquest.plugin.alignment.substitution.NearbySubstitutionMatrix;
import de.ugoe.cs.autoquest.plugin.alignment.substitution.ObjectDistanceSubstitionMatrix;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;
import de.ugoe.cs.util.console.GlobalDataContainer;

/**
 * <p>
 * Command to generate a binary alignment of two sequences
 * </p>
 * 
 * @author Ralph Krimmel
 * @version 1.0
 */
public class CMDbinaryAlignment implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@SuppressWarnings("unchecked")
	public void run(List<Object> parameters) {
		String sequencesName = "numberSequences";
		String substitutionName = "substitutionMatrix";
		String algorithm = "smithwaterman";
		try {
			sequencesName = (String) parameters.get(0);
			substitutionName = (String) parameters.get(1);
			if (parameters.size() > 2) {
				algorithm = (String) parameters.get(2);
			}
		} catch (Exception e) {
			throw new IllegalArgumentException();
		}

		SimpleSequenceGenerator gen;
		Object obj = GlobalDataContainer.getInstance().getData(sequencesName);
		if (obj != null) {
			if (obj instanceof SimpleSequenceGenerator) {
				gen = (SimpleSequenceGenerator) obj;
				Console.println("Number of sequences: " + gen.sequenceCount());

				int[] seq1 = gen.get(0).getSequence();
				int[] seq2 = gen.get(0).getSequence();
				
				ObjectDistanceSubstitionMatrix submat = new
				ObjectDistanceSubstitionMatrix();
				submat.generate(sequences);
				// SmithWaterman sw = new SmithWaterman(seq1, seq2,
				// new NearbySubstitutionMatrix(seq1, seq2, 10));
				// sw.printDPMatrix();
				// System.out.println();
				// sw.printAlignments();
				// sw.getMatches();
				System.out.println("foo");

			} else {
				Console.printerr("No number sequences generated. Please run the generateNumberSequences before.");
				
			}

					}

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public String help() {
		return "binaryAlignment <sequencesName> <substitutionMatrixname> {<algorithm>}";
	}

}
