package de.ugoe.cs.autoquest.tasktrees.alignment.matrix;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;

import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElement;
import de.ugoe.cs.autoquest.tasktrees.alignment.algorithms.AlignmentHelpers;
import de.ugoe.cs.autoquest.tasktrees.alignment.algorithms.Constants;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTaskInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstance;
import de.ugoe.cs.util.console.Console;

public class ObjectDistanceSubstitionMatrix implements SubstitutionMatrix {

	private HashMap<Integer, Integer> idmapping;
	private TriangleMatrix matrix;
	private HashSet<ITask> uniqueTasks;
	private double gapPenalty;
	private int index = 0;
	private HashMap<Integer, LinkedList<IEventTaskInstance>> etisOfTasks;
	private boolean calculateNonTaskInstances = true;

	private double positiveThreshold;

	public ObjectDistanceSubstitionMatrix(HashSet<ITask> uniqueTasks,
			float positiveThreshold, int gapPenalty,
			boolean calculateNonTaskInstances) {
		this.uniqueTasks = uniqueTasks;
		this.positiveThreshold = positiveThreshold;
		idmapping = new HashMap<Integer, Integer>();
		etisOfTasks = new HashMap<Integer, LinkedList<IEventTaskInstance>>();
		matrix = new TriangleMatrix(uniqueTasks.size() + 1);
		this.gapPenalty = gapPenalty;
		this.calculateNonTaskInstances = calculateNonTaskInstances;

	}

	public double getGapPenalty() {
		return gapPenalty;
	}

	public void setGapPenalty(double gapPenalty) {
		this.gapPenalty = gapPenalty;
	}

	private void searchEventTaskInstances() {
		int count = 0;
		for (Iterator<ITask> it = uniqueTasks.iterator(); it.hasNext();) {
			count++;
			
			ITask task = it.next();
			if (!(task instanceof IEventTask)) {
				EventTaskInstancesListGenerator etlg = new EventTaskInstancesListGenerator();
				task.accept(etlg);
				LinkedList<IEventTaskInstance> eventTaskInstances = etlg
						.getEventlist();
				etisOfTasks.put(task.getId(), eventTaskInstances);
			}
		}

	}

	public void generate() {
		if (this.calculateNonTaskInstances) {
			Console.traceln(Level.INFO, "	searching EventTasks in Tasks");
			searchEventTaskInstances();
		}
		Console.traceln(Level.INFO, "   calculating distances");
		int index1 = -1;
		int index2 = -1;
		double distance = 0;
		int count = 0;
		for (Iterator<ITask> it = uniqueTasks.iterator(); it.hasNext();) {
			count++;
			
			ITask task1 = it.next();
			for (Iterator<ITask> jt = uniqueTasks.iterator(); jt.hasNext();) {
				ITask task2 = jt.next();
				ITaskInstance ti1 = null;
				ITaskInstance ti2 = null;
				// We just need to the first instance here
				if (task1.getInstances().size() > 0) {
					ti1 = (ITaskInstance) task1.getInstances().iterator()
							.next();
				}
				if (task2.getInstances().size() > 0) {
					ti2 = (ITaskInstance) task2.getInstances().iterator()
							.next();
				}
				IEventTaskInstance eti1 = null;
				IEventTaskInstance eti2 = null;

				if (ti1 instanceof IEventTaskInstance
						&& ti2 instanceof IEventTaskInstance) {
					eti1 = (IEventTaskInstance) ti1;
					index1 = getIndex(eti1);
					eti2 = (IEventTaskInstance) ti2;
					index2 = getIndex(eti2);
					distance = distanceBetweenInstances(eti1, eti2);
				} else if (ti1 instanceof IEventTaskInstance
						&& !(ti2 instanceof IEventTaskInstance)) {
					task1 = ((ITaskInstance) ti1).getTask();
					index2 = getIndex(task2);
					eti1 = (IEventTaskInstance) ti1;
					index1 = getIndex(eti1);
					distance = distanceBetweenTaskAndInstance(task2, eti1);
				} else if (!(ti1 instanceof IEventTaskInstance)
						&& ti2 instanceof IEventTaskInstance) {
					index1 = getIndex(task1);
					eti2 = (IEventTaskInstance) ti2;
					index2 = getIndex(eti2);
					distance = distanceBetweenTaskAndInstance(task1, eti2);
				} else if (!(ti1 instanceof IEventTaskInstance)
						&& !(ti2 instanceof IEventTaskInstance)) {
					index1 = getIndex(task1);
					index2 = getIndex(task2);
					distance = distanceBetweenTasks(task1, task2);
				} else {
					System.out.println("Unknown error");
				}

				matrix.set(index1, index2, distance);

			}
		}
	}

	private double distanceBetweenTaskAndInstance(ITask task1,
			IEventTaskInstance eti1) {
		if (this.calculateNonTaskInstances) {
			float tmpDistance = 0;
			LinkedList<IEventTaskInstance> eventTaskInstances = etisOfTasks
					.get(task1.getId());
			for (Iterator<IEventTaskInstance> it = eventTaskInstances
					.iterator(); it.hasNext();) {
				IEventTaskInstance eti2 = it.next();
				int taskId1 = eti1.getTask().getId();
				int taskId2 = eti2.getTask().getId();
				if (scoreExists(taskId1, taskId2)) {
					tmpDistance += getScore(taskId1, taskId2);
				} else {
					double dist = distanceBetweenInstances(eti1, eti2);
					matrix.set(getIndex(eti1), getIndex(eti2), dist);
					tmpDistance += dist;
				}
			}
			return tmpDistance / eventTaskInstances.size();
		} else {
			return 0;
		}
	}

	public boolean scoreExists(int id, int id2) {
		return idmapping.containsKey(id) && idmapping.containsKey(id2);
	}

	private double distanceBetweenTasks(ITask task1, ITask task2) {
		if (this.calculateNonTaskInstances) {
			LinkedList<IEventTaskInstance> eventTaskInstances = etisOfTasks
					.get(task1.getId());
			float tmpDistance = 0;
			for (Iterator<IEventTaskInstance> it = eventTaskInstances
					.iterator(); it.hasNext();) {
				IEventTaskInstance eti1 = it.next();
				tmpDistance += distanceBetweenTaskAndInstance(task2, eti1);
			}

			return tmpDistance / eventTaskInstances.size();
		} else {
			return 0;
		}
	}

	private int getIndex(ITask task) {
		int tempindex = -1;

		if (!idmapping.containsKey(task.getId())) {
			idmapping.put(task.getId(), index);
			tempindex = index;
			index++;
		} else {
			tempindex = idmapping.get(task.getId());
		}

		return tempindex;
	}

	private int getIndex(IEventTaskInstance eti) {
		int tempindex = -1;
		if (!idmapping.containsKey(eti.getTask().getId())) {
			idmapping.put(eti.getTask().getId(), index);
			tempindex = index;
			index++;
		} else {
			tempindex = idmapping.get(eti.getTask().getId());
		}
		return tempindex;
	};

	private double distanceBetweenInstances(IEventTaskInstance eti1,
			IEventTaskInstance eti2) {
		IGUIElement first = (IGUIElement) eti1.getEvent().getTarget();
		IGUIElement second = (IGUIElement) eti2.getEvent().getTarget();
		float distance = -1 * AlignmentHelpers.distanceBetween(first, second);
		distance += positiveThreshold;
		return distance;
	}

	public String toString() {
		return matrix.toString();
	}

	public double getScore(int taskId1, int taskId2) {
		if (taskId1 == Constants.GAP_SYMBOL
				|| taskId1 == Constants.UNMATCHED_SYMBOL
				|| taskId2 == Constants.GAP_SYMBOL
				|| taskId2 == Constants.UNMATCHED_SYMBOL) {
			return 0.0;
		} else {
			Integer first = idmapping.get(taskId1);
			Integer second = idmapping.get(taskId2);
			return matrix.get(first, second);
		}

	}

}
