/**
 * 
 */
package de.ugoe.cs.autoquest.tasktrees.alignment.matrix;

import java.util.HashSet;
import java.util.LinkedList;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;

/**
 * @author Ralph Krimmel
 *
 */
public class NearbySubstitutionMatrix implements SubstitutionMatrix {

	private int[] input1;
	private int[] input2;
	private int range;
	
	public NearbySubstitutionMatrix(int[] input1,int[] input2, int range) {
		this.input1 = input1;
		this.input2 = input2;
		this.range = range;
	}
	
	/* (non-Javadoc)
	 * @see de.ugoe.cs.autoquest.plugin.alignment.SubstitutionMatrix#getDistance(int, int)
	 */
	public double getScore(int pos1, int pos2) {
		int difference = Math.abs(input1[pos1]-input2[pos2]); 
		if(difference < range) {
			return range-difference;
		}
		else {
			return -range;
		}
	}


	@Override
	public double getGapPenalty() {
		return -range-1;
	}



	@Override
	public void generate(HashSet<ITask> uniqueTasks) {
	}

	@Override
	public void update(LinkedList<ITask> newlyGeneratedTasks) {
	}

	

}
