//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usageprofiles;

/**
 * <p>
 * Default implementation of a {@link SymbolStrategy}. Uses a {@link DefaultSymbolComparator} and
 * a {@link DefaultSymbolMap} for managing symbols.
 * </p>
 * 
 * @author Patrick Harms
 * 
 * @see SymbolStrategy
 */
public class DefaultSymbolStrategy<T> implements SymbolStrategy<T> {
    
    /**
     * default serial version id
     */
    private static final long serialVersionUID = 1L;
    
    /**
     * the comparator used in this strategy
     */
    private SymbolComparator<T> comparator = new DefaultSymbolComparator<T>();

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.usageprofiles.SymbolStrategy#getSymbolComparator()
     */
    @Override
    public SymbolComparator<T> getSymbolComparator() {
        return comparator;
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.usageprofiles.SymbolStrategy#createSymbolMap()
     */
    @Override
    public <V> SymbolMap<T, V> createSymbolMap() {
        return new DefaultSymbolMap<T, V>();
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.usageprofiles.SymbolStrategy#copySymbolMap(de.ugoe.cs.autoquest.usageprofiles.SymbolMap)
     */
    @Override
    public <V> SymbolMap<T, V> copySymbolMap(SymbolMap<T, V> other) {
        return new DefaultSymbolMap<T, V>(other);
    }

}
