package de.ugoe.cs.autoquest.tasktrees.alignment.matrix;

import java.util.ArrayList;

//Must be initialized!
public class TriangleMatrix {
	
	private ArrayList<Float> matrix;
	protected int size;
	private float initalizationValue;
	
	
	
	//Increases the size
	public void increaseSize(int count) {
		int oldsize = size;
		this.size += count;
		matrix.ensureCapacity(size*(size+1/2));
		for(int i=0;i<(oldsize*count)+(count*(count+1)/2);i++) {
			matrix.add(this.initalizationValue);
		}
	}


	public TriangleMatrix(int size) {
		this.size = size;
		matrix = new ArrayList<Float>();
		matrix.ensureCapacity(size*(size+1/2));
	}

	
	public float get(int first, int second) {
		int row = Math.min(first, second);
		int col = Math.max(first, second);
		return matrix.get(row*size-(row*(row+1)/2 - (size-col)));
		
	}
	
	public void set(int first, int second, float value) {
		int row = Math.min(first, second);
		int col = Math.max(first, second);
		matrix.set(row*size-(row*(row+1)/2 - (size-col)),value);
	}

	public void initialize(float value) {
		this.initalizationValue = value;
		matrix.clear();
		for (int i=0; i < this.size*(this.size+1)/2; i++) {
			matrix.add(value);
		}
	}
	
	
	public String toString() {
		String result = "";
		for (int i = 0; i < size; i++) {
			for(int j = 0; j< size; j++) {
				if(i<j) {
					if(Float.isInfinite(this.get(i,j))) {
						result = result + " -------";
					}
					else {
						result = result + String.format("%+8.2f",this.get(i,j));
					}
				}
				else {
					result = result + ("        ");
				}
			}
			result = result + "\n";
		}
		return result;
	}
}
