//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskModel;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 16.07.2012$
 * @author 2012, last modified by $Author: pharms$
 */
public class UsabilityEvaluationResult {
    
    /** */
    private ITaskModel taskModel;
    
    /** */
    private List<UsabilityDefect> defects = new ArrayList<UsabilityDefect>();

    /**
     *
     */
    public UsabilityEvaluationResult(ITaskModel taskModel) {
        this.taskModel = taskModel;
    }

    /**
     *
     */
    public UsabilityEvaluationResult(ITaskModel                      taskModel,
                                     List<UsabilityEvaluationResult> results)
    {
        this.taskModel = taskModel;
        for (UsabilityEvaluationResult result : results) {
            for (UsabilityDefect defect : result.getAllDefects()) {
                defects.add(defect);
            }
        }
    }

    /**
     *
     */
    public void addDefect(UsabilityDefectSeverity    severity,
                          UsabilityDefectDescription description,
                          Map<String, Object>        parameters)
    {
        defects.add(new UsabilityDefect(severity, description, parameters));
    }

    /**
     *
     */
    public List<UsabilityDefect> getAllDefects() {
        return defects;
    }

    /**
     *
     */
    public List<UsabilityDefect> getSevereDefects() {
        List<UsabilityDefect> severeDefects = new ArrayList<UsabilityDefect>();

        for (UsabilityDefect defect : defects) {
            if (defect.getSeverity() == UsabilityDefectSeverity.HIGH) {
                severeDefects.add(defect);
            }
        }

        return severeDefects;
    }

    /**
     * @return the taskModel
     */
    public ITaskModel getTaskModel() {
        return taskModel;
    }

}
