package de.ugoe.cs.autoquest.tasktrees.alignment.matrix;




import de.ugoe.cs.autoquest.tasktrees.alignment.algorithms.AlignmentAlgorithm;


public class PairwiseAlignmentStorage {

    private AlignmentAlgorithm[][] alignments;
    private UPGMAMatrix sequenceDistances;
   
    public PairwiseAlignmentStorage(int sizex, int sizey) {
    	alignments = new AlignmentAlgorithm[sizex+1][sizey+1];
    	sequenceDistances = new UPGMAMatrix(Math.max(sizex,sizey));
    	sequenceDistances.initialize(Float.POSITIVE_INFINITY);
    }
 
    
    
    public void set(int i,int j,AlignmentAlgorithm sw) {
    	alignments[i][j] = sw;
    }
    
    public AlignmentAlgorithm get(int i,int j) {
    	return alignments[i][j];
    }
    
    public void setDistance(int i,int j,float distance) {
    	sequenceDistances.set(i, j, distance);
    }
    
    public double getDistance(int i,int j) {
    	return sequenceDistances.get(i,j);
    }
    
    public UPGMAMatrix getDistanceMatrix() {
    	return sequenceDistances;
    }
}

