//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.http;

import static org.junit.Assert.*;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.junit.Test;

import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.autoquest.plugin.http.HTTPLogParser;
import de.ugoe.cs.autoquest.plugin.http.HTTPUtils;
import de.ugoe.cs.autoquest.plugin.http.eventcore.SOAPEventType;
import de.ugoe.cs.autoquest.plugin.http.eventcore.SimpleSOAPEventType;

/**
 * <p>
 * Tests for the HTTPUtils
 * </p>
 * 
 * @author Steffen Herbold
 */
public class HTTPUtilsTest {
    
    @Test
    public void testConvertToSimpleSOAPEvent_1() throws Exception {
        HTTPLogParser parser =
                new HTTPLogParser(new File(ClassLoader
                    .getSystemResource("testParseFile_3_properties.txt").getFile()));
            parser.parseFile(new File(ClassLoader.getSystemResource("testParseFile_3_logfile.log")
                .getFile()));
            Collection<List<Event>> events = parser.getSequences();

            assertNotNull(events);
            assertEquals(1, events.size());

            List<Event> sequence = events.iterator().next();
            
            List<Event> newSequence = HTTPUtils.convertToSimpleSOAPEvent(sequence);
            
            assertNotNull(newSequence);
            assertEquals(sequence.size(), newSequence.size());
            
            Iterator<Event> oldSeqIter = sequence.iterator();
            Iterator<Event> newSeqIter = newSequence.iterator();
            
            while(oldSeqIter.hasNext()) {
                Event oldEvent = oldSeqIter.next();
                Event newEvent = newSeqIter.next();
                
                if( oldEvent.getType() instanceof SOAPEventType ) {
                    assertTrue(newEvent.getType() instanceof SimpleSOAPEventType);
                    SOAPEventType oldEventType = (SOAPEventType) oldEvent.getType();
                    SimpleSOAPEventType newEventType = (SimpleSOAPEventType) newEvent.getType();
                    assertEquals(oldEventType.getCalledMethod(), newEventType.getCalledMethod());
                    assertEquals(oldEventType.getServiceName(), newEventType.getServiceName());
                    assertNull(newEvent.getTarget());
                } else {
                    assertSame(oldEvent, newEvent);
                }
            }
            
    }

}
