//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.util.console.defaultcommands;

import java.util.List;

import de.ugoe.cs.util.console.Command;

/**
 * <p>
 * Command to terminate an application.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDexit implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see databasebuilder.console.commands.Command#help()
	 */
	@Override
	public String help() {
		return "exit";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		System.exit(0);
	}

}
