package de.ugoe.cs.eventbench.commands;

import java.security.InvalidParameterException;
import java.util.List;

import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.eventbench.models.Trie;
import de.ugoe.cs.eventbench.models.TrieBasedModel;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Command that prints the {@link Trie} of a {@link TrieBasedModel} as dot to
 * the console.
 * </p>
 * 
 * @author Steffen Herbold
 * @version
 */
public class CMDprintTrieDot implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public void help() {
		Console.println("Usage: printTreeDot <modelname>");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		String modelname = "";
		try {
			modelname = (String) parameters.get(0);
		} catch (Exception e) {
			throw new InvalidParameterException();
		}

		TrieBasedModel model = null;
		Object dataObject = GlobalDataContainer.getInstance()
				.getData(modelname);
		if (dataObject == null) {
			Console.println("Model " + modelname + "not found in storage.");
		} else if (!(dataObject instanceof TrieBasedModel)) {
			Console.println("Object " + modelname + " is not a TrieBasedModel!");
		} else {
			model = (TrieBasedModel) dataObject;
			Console.println(model.getTrieDotRepresentation());
		}
	}

}
